---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-kubectl drain 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **drain.Helper内部のEviction/DELETEロジック**：pkgパッケージのdrain.Helper実装は別ファイルであり、詳細動作の確認が必要
  2. **PDB制約の具体的なエラーメッセージ**：PDB違反時のエラーはAPI Server側で生成されるため、正確な文面は要確認
  3. **DaemonSet/emptyDir/管理外Podの判定ロジック**：filters.goの実装に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L44-55（DrainCmdOptions）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L115-147（drainLong/drainExample）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L149-164（NewDrainCmdOptions）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L167-209（コールバック関数）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L211-239（NewCmdDrain）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L243-322（Complete）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L325-364（RunDrain）
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L366-398（deleteOrEvictPodsSimple）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.17行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | drainはまずcordonを実行してからPod退避する | E-07 L326-328 | ○ |
| C-02 | EvictErrorRetryDelayは5秒 | E-03 L155 | ○ |
| C-03 | Pod退避開始・完了のコールバックが設定される | E-03 L161-163, E-04 L167-209 | ○ |
| C-04 | --forceフラグでコントローラー管理外Podも削除 | E-05 L226 | ○ |
| C-05 | --ignore-daemonsetsフラグでDaemonSet管理Pod無視 | E-05 L227 | ○ |
| C-06 | --delete-emptydir-dataフラグでemptyDir Podも退避 | E-05 L228 | ○ |
| C-07 | --grace-periodのデフォルトは-1（Podデフォルト使用） | E-03 L154 | ○ |
| C-08 | --disable-evictionでEviction APIを無効化可能 | E-05 L232 | ○ |
| C-09 | 一部ノード失敗時は他ノードの処理を続行 | E-07 L334-353 | ○ |
| C-10 | 残留ノードを最後に報告する | E-07 L356-361 | ○ |
| C-11 | dry-run=client時はPod名表示のみ | E-08 L374-379 | ○ |
| C-12 | 退避中エラー時に残留Podを表示 | E-08 L382-394 | ○ |
| C-13 | チャンクサイズのデフォルトはDefaultChunkSize | E-03 L158 | ○ |
| C-14 | --pod-selectorでPodラベルフィルタ | E-05 L231, E-06 L262-265 | ○ |
| C-15 | Eviction APIが利用可能な場合はEvictionを使用しPDBを尊重 | E-02 drainLong（L120-121） | ○ |
| C-16 | drain.Helper内部のDeleteOrEvictPodsの具体的なEviction/DELETE分岐ロジック | drain.go (pkg)（未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-16のdrain.Helper.DeleteOrEvictPodsの内部実装は`staging/src/k8s.io/kubectl/pkg/drain/drain.go`に存在するが、本分析ではこのファイルの詳細まで追跡していない。
  - 候補：`staging/src/k8s.io/kubectl/pkg/drain/drain.go` / `staging/src/k8s.io/kubectl/pkg/drain/filters.go`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - drain.Helper内部のEviction/DELETE分岐ロジックは別パッケージの実装に依存
- 0: 低リスク - フラグの仕様はNewCmdDrainのフラグ登録コードから直接確認可能
- 1: 中リスク - PDB制約のエラーハンドリングはAPI Server側の挙動に依存

## 6) レビュアーチェックリスト（最小）
- [ ] drain.Helper.DeleteOrEvictPodsの内部Eviction/DELETE分岐を確認
- [ ] DaemonSet/emptyDir/管理外Podの判定ロジック（filters.go）を確認
- [ ] PDB制約違反時の具体的なエラーメッセージを実機確認
- [ ] --disable-evictionの安全性に関する運用ガイダンスを確認
- [ ] 複数ノードdrain時の並行性（順次処理）を確認
