---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-kubectl taint 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **parseTaints/reorganizeTaintsの内部実装**：utils.goファイルの詳細は未確認
  2. **操作結果メッセージ（tainted/untainted/modified）の判定ロジック**：reorganizeTaints戻り値に依存
  3. **Taint Evictionコントローラーの動作**：taintコマンドのスコープ外

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L47-68（TaintOptions）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L70-97（taintLong/taintExample）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L99-129（NewCmdTaint）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L132-207（Complete）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L210-260（validateFlags/Validate）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L263-351（RunTaint）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` L355-371（updateTaints）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.18行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Taintはkey=value:effect形式で指定 | E-02 L82-96（例示） | ○ |
| C-02 | effectはNoSchedule/PreferNoSchedule/NoExecuteの3種類 | E-02 L78 | ○ |
| C-03 | リソース種別はNodeのみ | E-05 L239 | ○ |
| C-04 | 引数の順序制約（リソースはTaintの前） | E-04 L168-170 | ○ |
| C-05 | --overwrite未指定時の既存Taint重複エラー | E-07 L360-363 | ○ |
| C-06 | 同一キーの追加・削除同時指定エラー | E-05 L244-258 | ○ |
| C-07 | --allとselectorは排他 | E-05 L212-213 | ○ |
| C-08 | Strategic Merge Patchで更新 | E-06 L288 | ○ |
| C-09 | パッチ失敗時はReplace操作にフォールバック | E-06 L341-345 | ○ |
| C-10 | dry-run=clientはローカルマージ結果を表示 | E-06 L298-326 | ○ |
| C-11 | key長最大253文字、value長最大63文字 | E-03 L111 | ○ |
| C-12 | Taint引数の判定は=/:含有またはハイフン末尾 | E-04 L159 | ○ |
| C-13 | フィールドマネージャデフォルトは"kubectl-taint" | E-03 L127 | ○ |
| C-14 | parseTaints/reorganizeTaintsの具体的な内部ロジック | utils.go（未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-14のparseTaints/reorganizeTaintsの内部実装は`staging/src/k8s.io/kubectl/pkg/cmd/taint/utils.go`に存在するが、本分析では追跡していない。
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/taint/utils.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フラグ仕様はソースコードから直接確認可能
- 1: 中リスク - parseTaints/reorganizeTaintsの内部ロジック未確認
- 0: 低リスク - Strategic Merge Patch/Replaceのフォールバックはソースコード確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] parseTaints（utils.go）のTaint文字列パース仕様を確認
- [ ] reorganizeTaintsの戻り値（操作種別文字列）を確認
- [ ] NoExecute Taint追加後のTaint Evictionコントローラー動作を確認
- [ ] --overwriteフラグの具体的な動作を確認
