---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-kubectl_expose 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Service管理（機能No.139）の詳細動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/expose/expose.go` - 主要ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.2の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 対象リソースからServiceを作成する | E-01 (行52-64: exposeLong) | ○ |
| C-02 | pod, svc, rc, deploy, rsが対象リソース | E-01 (行50: exposeResources) | ○ |
| C-03 | セレクタ未指定時は対象リソースから推定 | E-01 (行328-334) | ○ |
| C-04 | ポート未指定時は対象リソースから推定 | E-01 (行340-355) | ○ |
| C-05 | 複数ポート対応 | E-01 (行345-355, 473-521) | ○ |
| C-06 | プロトコルのデフォルトはTCP | E-01 (行490-491) | ○ |
| C-07 | ラベル未指定時はリソースのラベルを引き継ぐ | E-01 (行367-373) | ○ |
| C-08 | ClusterIP, NodePort, LoadBalancer, ExternalNameをサポート | E-01 (行207, 551-556) | ○ |
| C-09 | SessionAffinityはNone/ClientIPが有効 | E-01 (行558-565) | ○ |
| C-10 | headless serviceはClusterIP=None | E-01 (行568-569) | ○ |
| C-11 | DNS1035ラベル最大長でトランケート | E-01 (行321-323) | ○ |
| C-12 | field-managerデフォルトはkubectl-expose | E-01 (行217) | ○ |
| C-13 | CanBeExposedで公開可能性を確認 | E-01 (行316) | ○ |
| C-14 | createService()でServiceオブジェクト構築 | E-01 (行376-378, 430-575) | ○ |
| C-15 | resource.NewHelper().Create()でAPI送信 | E-01 (行417-421) | ○ |
| C-16 | OverrideOptionsの適用 | E-01 (行381-383) | ○ |
| C-17 | DryRunClient時はPrintObjのみ | E-01 (行390-395) | ○ |
| C-18 | parseLabelsでラベル文字列をパース | E-01 (行578-595) | ○ |
| C-19 | parseProtocolsでプロトコル文字列をパース | E-01 (行608-629) | ○ |
| C-20 | Service管理機能（No.139）との連携 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Service管理機能（No.139）はkubectl側ではなくkube-controller-manager側の処理であり、kubectlソースからは確認不可
  - 候補：kube-controller-manager / Service controller / endpoint controller

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドフラグ、バリデーション、Service生成ロジックはソースコードから直接確認済み
- 0: 低リスク - 対象リソースタイプの一覧はソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 対象リソースタイプ（pod, svc, rc, deploy, rs）が最新と一致するか確認
- [ ] Service生成ロジック（特にマルチポート、プロトコルマッピング）が正確か確認
- [ ] エラーメッセージが網羅的か確認
