---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-kubectl_attach 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件**：pods/attach サブリソースの権限要件はコード内に明示されていない

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` - AttachOptions構造体、NewCmdAttach、Complete、Validate、Run関数
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/exec/exec.go` - StreamOptions構造体、SetupTTY関数
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.21の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.114, 66のマッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - kubectl attach の位置付け

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | attach はメインプロセスに接続する | E-01 (行111: "Attach to a process that is already running") | ○ |
| C-02 | AttachOptions は exec.StreamOptions を埋め込む | E-01 (行73: `exec.StreamOptions`) | ○ |
| C-03 | デフォルトタイムアウトは60秒 | E-01 (行67: `defaultPodAttachTimeout = 60 * time.Second`) | ○ |
| C-04 | -c, -i, -t, -q フラグが存在 | E-01 (行121-124) | ○ |
| C-05 | Complete で namespace と REST Config を取得 | E-01 (行201, 217-221) | ○ |
| C-06 | Validate で引数1-2個を確認 | E-01 (行232-237) | ○ |
| C-07 | Succeeded/Failed の Pod にはアタッチ不可 | E-01 (行269-271) | ○ |
| C-08 | コンテナTTYとリクエストTTYの整合性チェック | E-01 (行280-289) | ○ |
| C-09 | TTY raw モードで stderr が無効化 | E-01 (行309) | ○ |
| C-10 | WebSocket -> SPDY フォールバック | E-01 (行176-196, createExecutor) | ○ |
| C-11 | REST API は pods/attach サブリソースへのPOST | E-01 (行140-144) | ○ |
| C-12 | 記録警告メッセージが表示される | E-01 (行313) | ○ |
| C-13 | 再接続メッセージが表示される | E-01 (行354-362, reattachMessage) | ○ |
| C-14 | default-container アノテーションでコンテナ選択 | E-01 (行337-341, containerToAttachTo -> podcmd.FindOrDefaultContainerByName) | ○ |
| C-15 | 関連機能No.114 Attach | E-04 | ○ |
| C-16 | 関連機能No.66 Kubelet API Server | E-04 | ○ |
| C-17 | カテゴリは Troubleshooting and Debugging | E-03 | ○ |
| C-18 | pods/attach サブリソースのRBAC権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: RBAC権限要件はKubernetes APIサーバー側の仕様であり、kubectl のソースコード内には明示的な権限チェックロジックは存在しない。API サーバーが認可を行う。
  - 候補：Kubernetes API Server のRBAC実装 / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード内の行番号参照は全て実際のソースコードと一致
- 0: 低リスク - フラグ仕様はコードから正確に抽出
- 1: 中リスク - RBAC権限の記載はKubernetesの一般的な仕様に基づくが、コード内に直接的な根拠はない

## 6) レビュアーチェックリスト（最小）
- [ ] AttachOptions の各フィールドと説明が一致するか確認
- [ ] メッセージ仕様のメッセージ文言がソースコードと一致するか確認
- [ ] RBAC権限要件が正しいか公式ドキュメントで確認
- [ ] エフェメラルコンテナのセッション終了メッセージが正しく記載されているか確認
