---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：22-kubectl_exec 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件**：pods/exec サブリソースの権限要件はコード内に明示されていない

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/exec/exec.go` - ExecOptions、StreamOptions、NewCmdExec、Complete、Validate、Run
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.22の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.88, 66のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec は新しいプロセスを起動する | E-01 (行92-93: "Execute a command in a container") | ○ |
| C-02 | デフォルトタイムアウトは60秒 | E-01 (行78: `defaultPodExecTimeout = 60 * time.Second`) | ○ |
| C-03 | ArgsLenAtDash で -- の位置を取得 | E-01 (行97: `argsLenAtDash := cmd.ArgsLenAtDash()`) | ○ |
| C-04 | Pod名未指定でリソース名未指定でファイル未指定の場合エラー | E-01 (行249) | ○ |
| C-05 | コマンド未指定の場合エラー | E-01 (行252-253) | ○ |
| C-06 | Succeeded/Failed Podでexec不可 | E-01 (行350-351) | ○ |
| C-07 | 複数オブジェクトへのexec不可 | E-01 (行338-339) | ○ |
| C-08 | REST API は pods/exec サブリソースへのPOST | E-01 (行385-389) | ○ |
| C-09 | WebSocket -> SPDY フォールバック | E-01 (行146-166, createExecutor) | ○ |
| C-10 | TTY raw モードで ErrOut が nil に設定 | E-01 (行375) | ○ |
| C-11 | kubectl cp が内部的に exec を使用 | E-01 (行317-318: コメント参照) | ○ |
| C-12 | 旧形式引数のエラーメッセージ | E-01 (行214) | ○ |
| C-13 | -f フラグでリソース指定可能 | E-01 (行104) | ○ |
| C-14 | 関連機能No.88 コンテナ実行 | E-03 | ○ |
| C-15 | 関連機能No.66 Kubelet API Server | E-03 | ○ |
| C-16 | Deployment/Service指定時に自動Pod選択 | E-01 (行342: `ExecutablePodFn`) | ○ |
| C-17 | pods/exec のRBAC権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: RBAC権限はAPIサーバー側で制御されるため、kubectlのコード内には直接的な権限チェックは存在しない。
  - 候補：Kubernetes API Server RBAC / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 行番号参照は全て正確
- 0: 低リスク - フラグ仕様はコードから正確に抽出
- 1: 中リスク - RBAC権限記載は一般的知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] ExecOptions の各フィールドとドキュメントの記載が一致するか確認
- [ ] メッセージ仕様がソースコードの文言と一致するか確認
- [ ] `--` セパレータの仕様が正しく記載されているか確認
