---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-kubectl_port-forward 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/portforward/portforward.go` - PortForwardOptions、Complete、Validate、RunPortForwardContext
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.23の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.89, 66のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトタイムアウト60秒 | E-01 (行99: `defaultPodPortForwardWaitTimeout = 60 * time.Second`) | ○ |
| C-02 | デフォルトアドレスはlocalhost | E-01 (行118: `"address", []string{"localhost"}`) | ○ |
| C-03 | 引数2未満でエラー | E-01 (行320-321) | ○ |
| C-04 | PodがRunning以外でエラー | E-01 (行428-429) | ○ |
| C-05 | UDPポート非サポート | E-01 (行275: "UDP protocol is not supported") | ○ |
| C-06 | Service targetPort自動変換 | E-01 (行185-218: translateServicePortToTargetPort) | ○ |
| C-07 | 名前付きポート解決 | E-01 (行222-248: convertPodNamedPortToNumber) | ○ |
| C-08 | WebSocket -> SPDYフォールバック | E-01 (行145-156: createDialer) | ○ |
| C-09 | SIGINTでStopChannelクローズ | E-01 (行439-447) | ○ |
| C-10 | REST APIはpods/portforwardサブリソース | E-01 (行449-453) | ○ |
| C-11 | ランダムポート割り当て可能 | E-01 (行94: "kubectl port-forward pod/mypod :5000") | ○ |
| C-12 | --address 0.0.0.0で全IF対応 | E-01 (行88: "--address 0.0.0.0") | ○ |
| C-13 | 関連機能No.89 ポートフォワード | E-03 | ○ |
| C-14 | 関連機能No.66 Kubelet API Server | E-03 | ○ |
| C-15 | splitPort関数でLOCAL:REMOTE分離 | E-01 (行172-179) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] PortForwardOptions の構造体フィールドが正しく記載されているか確認
- [ ] Service ポートマッピングの説明が実装と一致するか確認
- [ ] UDPポートチェックのロジックが正しく記載されているか確認
