---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-kubectl_proxy 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` - NewCmdProxy、Run関数
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.24の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.90のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトポートは8001 | E-01 (行43: `"port", "p", 8001`) | ○ |
| C-02 | デフォルトアドレスは127.0.0.1 | E-01 (行44: `"address", "127.0.0.1"`) | ○ |
| C-03 | デフォルトで exec/attach パスが拒否 | E-01 (行47: `"reject-paths"... "^/api/.*/pods/.*/exec,^/api/.*/pods/.*/attach"`) | ○ |
| C-04 | --disable-filter でXSRF警告表示 | E-01 (行57-58) | ○ |
| C-05 | UNIXソケットパーミッション0600 | E-01 (行83-84) | ○ |
| C-06 | accept-hosts デフォルトはlocalhost系 | E-01 (行48: `^localhost$,^127\.0\.0\.1$,^\[::1\]$`) | ○ |
| C-07 | wwwプレフィックスデフォルトは/static/ | E-01 (行51: `"www-prefix", "/static/"`) | ○ |
| C-08 | keepaliveデフォルトは無効 | E-01 (行54: `"keepalive", 0`) | ○ |
| C-09 | ポート0でランダムポート割当 | E-01 (行91-92: listener.Addr().String()) | ○ |
| C-10 | 起動メッセージ "Starting to serve on" | E-01 (行92) | ○ |
| C-11 | reject-methods デフォルトは ^$ | E-01 (行49: `"reject-methods", "^$"`) | ○ |
| C-12 | accept-paths デフォルトは ^.* | E-01 (行46: `"accept-paths", "^.*"`) | ○ |
| C-13 | api-prefix デフォルトは / | E-01 (行45: `"api-prefix", "/"`) | ○ |
| C-14 | 関連機能No.90 APIプロキシ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] フラグのデフォルト値がソースコードと一致するか確認
- [ ] セキュリティ関連の注意事項（disable-filter、XSRF）が正しく記載されているか確認
