---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-kubectl_cp 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/cp/cp.go` - CopyOptions、NewCmdCp、Complete、Validate、Run、copyToPod、copyFromPod、untarAll
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.25の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.91, 88のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 内部的にtarとexecを使用 | E-01 (行33-35: コメント、行218-256: copyToPod/copyFromPod) | ○ |
| C-02 | コンテナにtarバイナリ必要 | E-01 (行34: "It requires that 'tar' be present in your container") | ○ |
| C-03 | --retries でリトライ可能 | E-01 (行67-70, 142: `"retries", 0`) | ○ |
| C-04 | --no-preserve でパーミッション非保持 | E-01 (行140: `"no-preserve"`, 行209: `--no-same-permissions --no-same-owner`) | ○ |
| C-05 | extractFileSpec でsrc/dst解析 | E-01 (行362: extractFileSpec) | ○ |
| C-06 | 両方ローカルまたは両方リモートでエラー | E-01 (行185-188) | ○ |
| C-07 | パストラバーサル防止チェック | E-01 (行258-280: linkCleanPath) | ○ |
| C-08 | ローカル -> コンテナ: tar -xmf - | E-01 (行222-223) | ○ |
| C-09 | コンテナ -> ローカル: tar cf - | E-01 (行247-248) | ○ |
| C-10 | fileSpec構造体にPodNamespace,PodName,File | E-01 (行100-105) | ○ |
| C-11 | 引数は正確に2つ必要 | E-01 (行167-169: "must specify two arguments") | ○ |
| C-12 | 関連機能No.91 ファイルコピー | E-03 | ○ |
| C-13 | 関連機能No.88 コンテナ実行（内部利用） | E-03 | ○ |
| C-14 | ワイルドカード不可 | E-01 (行38: "kubectl cp does not support copying using wildcards") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] CopyOptions のフィールドが正しく記載されているか確認
- [ ] パストラバーサル防止ロジックが正しく説明されているか確認
- [ ] tar コマンドのオプション（-xmf, cf -）が実装と一致するか確認
