---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：26-kubectl_auth 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **SelfSubjectAccessReview の全ユーザー利用可能**：API サーバー側の仕様であり、コード内には明示されていない

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` - NewCmdAuth、3つのサブコマンド登録
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` - CanIOptions、NewCmdCanI
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` - ReconcileOptions
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` - WhoAmIFlags、NewWhoAmIFlags
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.26の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.92のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | auth は3つのサブコマンドを持つ | E-01 (行36-38: AddCommand can-i, reconcile, whoami) | ○ |
| C-02 | auth 直接実行でサブコマンド一覧表示 | E-01 (行33: DefaultSubCommandRun) | ○ |
| C-03 | can-i の CanIOptions に AllNamespaces, Quiet 等 | E-02 (行49-66) | ○ |
| C-04 | reconcile に RemoveExtraPermissions, RemoveExtraSubjects | E-03 (行46-60) | ○ |
| C-05 | reconcile はセマンティック対応マージ | E-03 (行63-74: reconcileLong) | ○ |
| C-06 | whoami は SelfSubjectReview API を使用 | E-04 (行79: authenticationv1alpha1client) | ○ |
| C-07 | whoami はバージョンフォールバック | E-04 (行79-80: v1alpha1, v1beta1, v1) | ○ |
| C-08 | can-i の結果は "yes"/"no" | E-02 (行69: canILong) | ○ |
| C-09 | --list で許可アクション一覧表示 | E-02 (行62: `List bool`) | ○ |
| C-10 | reconcile は apply より RBAC に適す | E-03 (行74: "preferred to 'apply' for RBAC resources") | ○ |
| C-11 | can-i は SubjectAccessReview で他者権限確認可能 | E-02 (行54: AuthClient authorizationv1client) | ○ |
| C-12 | reconcile は Role, ClusterRole, RoleBinding, ClusterRoleBinding を処理 | E-03 (行63-67: reconcileLong) | ○ |
| C-13 | 関連機能No.92 認可検査 | E-06 | ○ |
| C-14 | auth の説明は "Inspect authorization" | E-01 (行31: Short: "Inspect authorization") | ○ |
| C-15 | SelfSubjectAccessReview は全ユーザー利用可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: SelfSubjectAccessReview の全ユーザー利用可能性はKubernetes APIサーバーのRBAC仕様であり、kubectlのコードには直接記載なし。
  - 候補：Kubernetes 公式ドキュメント / API Server RBAC デフォルト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サブコマンド構成はコードから確認済み
- 1: 中リスク - SelfSubjectAccessReview の権限仕様はAPI側の話

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのサブコマンドの説明が正確か確認
- [ ] reconcile のセマンティックマージの説明が正確か確認
- [ ] whoami の API バージョンフォールバック順序が正しいか確認
