---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-kubectl_debug 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` - DebugOptions、NewCmdDebug、AddFlags、Complete、Validate、Run、visitNode、visitPod、debugByEphemeralContainer、debugByCopy
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.27の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.115, 114のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つのデバッグ戦略（エフェメラル/コピー/ノード） | E-01 (行68-77: debugLong) | ○ |
| C-02 | DebugOptionsに多数のフィールド | E-01 (行116-158) | ○ |
| C-03 | ShareProcessesデフォルトtrue | E-01 (行167) | ○ |
| C-04 | KeepInitContainersデフォルトtrue | E-01 (行165) | ○ |
| C-05 | プロファイルgeneral/baseline/restricted/netadmin/sysadmin | E-01 (行216: `ProfileGeneral`) | ○ |
| C-06 | legacyプロファイルv1.39削除予定 | E-01 (行404) | ○ |
| C-07 | --copy-to未使用で--image必須 | E-01 (行346) | ○ |
| C-08 | --targetと--copy-toは非互換 | E-01 (行377-379) | ○ |
| C-09 | -t指定で-i未指定はエラー | E-01 (行387-389) | ○ |
| C-10 | エフェメラルコンテナはStrategicMergePatch | E-01 (行507-514) | ○ |
| C-11 | PodコピーはPods.Create | E-01 (行628) | ○ |
| C-12 | --replaceで元Pod削除 | E-01 (行632-637) | ○ |
| C-13 | ノードPodはホストPID/Network/IPC | E-01 (行708-710: コメント) | ○ |
| C-14 | ノードPodにmanaged-byラベル | E-01 (行729-731) | ○ |
| C-15 | カスタムプロファイルでname,command,image変更不可 | E-01 (行397-399) | ○ |
| C-16 | アタッチ失敗時ログにフォールバック | E-01 (行994-997) | ○ |
| C-17 | 非rootユーザー警告 | E-01 (行642-665: displayWarning) | ○ |
| C-18 | コンテナ名自動生成(debugger-xxxxx) | E-01 (行872: `debugger-%s`) | ○ |
| C-19 | ノードPod名自動生成(node-debugger-xxx) | E-01 (行721: `node-debugger-%s-%s`) | ○ |
| C-20 | EphemeralContainers未対応時のエラー | E-01 (行518-519) | ○ |
| C-21 | 関連機能No.115 Debug | E-03 | ○ |
| C-22 | 関連機能No.114 Attach | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - プロファイル詳細（profiles.go）は別ファイルだが基本構造はdebug.goから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのデバッグ戦略の条件分岐が正しく記載されているか確認
- [ ] フラグの数と説明が実装と一致するか確認
- [ ] プロファイル一覧がprofiles.goと一致するか確認
- [ ] カスタムプロファイルの制約が正しいか確認
