---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-kubectl_events 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` - EventsFlags、EventsOptions、NewCmdEvents、ToOptions、Validate、Run、runWatch、SortableEvents
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.28の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.93のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Flags -> Options パターン | E-01 (行78-89: EventsFlags, 行103-117: EventsOptions) | ○ |
| C-02 | FilterTypesはNormal/Warningのみ | E-01 (行213: "valid --types are Normal or Warning") | ○ |
| C-03 | --for はresource/name形式必須 | E-01 (行176: "--for must be in resource/name form") | ○ |
| C-04 | イベントなし時のメッセージ | E-01 (行278-281) | ○ |
| C-05 | ウォッチモードでDeletedイベント非表示 | E-01 (行306: `watch.Deleted`) | ○ |
| C-06 | SortableEventsのソート優先順位 | E-01 (行366-374: Series -> LastTimestamp -> EventTime) | ○ |
| C-07 | --for はFieldSelectorでサーバー側フィルタ | E-01 (行229-233) | ○ |
| C-08 | FollowContinueでページネーション | E-01 (行246-254) | ○ |
| C-09 | デフォルトChunkSize | E-01 (行97: `cmdutil.DefaultChunkSize`) | ○ |
| C-10 | ウォッチはUntilWithoutRetry使用 | E-01 (行305) | ○ |
| C-11 | テーブル出力にLAST SEEN, TYPE, REASON, OBJECT, MESSAGE | E-01 (行50-56: eventsLong) | ○ |
| C-12 | decodeResourceTypeName でTYPE/NAME解析 | E-01 (行380-410) | ○ |
| C-13 | --chunk-size フラグ | E-01 (行148: AddChunkSizeFlag) | ○ |
| C-14 | 関連機能No.93 イベント一覧 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] テーブル出力のカラム名がevent_printer.goと一致するか確認
- [ ] ソートロジックの優先順位が正しいか確認
- [ ] FieldSelector の構築が正しいか確認
