---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-kubectl_diff 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/diff/diff.go` - DiffOptions、DiffProgram、InfoObject、Masker、Differ、NewCmdDiff、Complete、Run
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.29の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.94, 95のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力は常にYAML形式 | E-01 (行57: "The output is always YAML") | ○ |
| C-02 | KUBECTL_EXTERNAL_DIFF環境変数で外部diffプログラム指定 | E-01 (行59-60, 行191) | ○ |
| C-03 | デフォルトは diff -u -N | E-01 (行206: `args = append([]string{"-u", "-N"}, args...)`) | ○ |
| C-04 | Secretのdataフィールドマスク | E-01 (行582-588, 行488-531) | ○ |
| C-05 | マスクは *** / *** (before) / *** (after) | E-01 (行89-92: sensitiveMaskDefault/Before/After) | ○ |
| C-06 | maxRetries = 4 | E-01 (行85) | ○ |
| C-07 | 終了コード: 0=差分なし, 1=差分あり, >1=エラー | E-01 (行66-72) | ○ |
| C-08 | managedFieldsデフォルト除外 | E-01 (行576-580: omitManagedFields) | ○ |
| C-09 | --concurrency で並列処理 | E-01 (行172: `"concurrency", 1`) | ○ |
| C-10 | InfoObject.Live()で現在状態取得 | E-01 (行340-342) | ○ |
| C-11 | InfoObject.Merged()でドライラン結果取得 | E-01 (行346-408) | ○ |
| C-12 | SSA時はApplyPatchTypeでPatch | E-01 (行359-366) | ○ |
| C-13 | CSA新規時はhelper.Create(dryRun) | E-01 (行371-377) | ○ |
| C-14 | --prune でプルーニング対象表示 | E-01 (行169: `"prune", false`) | ○ |
| C-15 | --force-conflicts は --server-side 必須 | E-01 (行639-641) | ○ |
| C-16 | 関連機能No.94 差分表示 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Secret マスクロジックが正しく説明されているか確認
- [ ] 終了コードの仕様が実装と一致するか確認
- [ ] SSA/CSA のマージ計算パスが正しく記載されているか確認
