---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-kubectl_run 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **PodSecurityPolicy/Pod Security Standardの制約**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` - 主要ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.3の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンテナイメージからPodを作成 | E-01 (行62: runLong) | ○ |
| C-02 | --imageは必須フラグ | E-01 (行178) | ○ |
| C-03 | イメージ名のバリデーションにReferenceRegexpを使用 | E-01 (行261) | ○ |
| C-04 | -i指定時にattachが自動true | E-01 (行216-219) | ○ |
| C-05 | -tは-iなしでは使用不可 | E-01 (行265-267) | ○ |
| C-06 | --exposeには--portが必須 | E-01 (行268-270) | ○ |
| C-07 | --rmはアタッチ時のみ有効 | E-01 (行282-284) | ○ |
| C-08 | ドライランとアタッチは排他的 | E-01 (行286-288) | ○ |
| C-09 | デフォルトリスタートポリシーはAlways | E-01 (行188, 546) | ○ |
| C-10 | interactive時のデフォルトはOnFailure | E-01 (行543-544) | ○ |
| C-11 | Pod起動待ちタイムアウトのデフォルトは60秒 | E-01 (行94) | ○ |
| C-12 | handleAttachPodでPod起動を待機 | E-01 (行471-510) | ○ |
| C-13 | waitForPodでwatch APIを使用 | E-01 (行442-469) | ○ |
| C-14 | アタッチ失敗時はログストリーミングにフォールバック | E-01 (行506-508) | ○ |
| C-15 | podCompleted条件でFailed/Successedを監視 | E-01 (行688-701) | ○ |
| C-16 | podRunningAndReadyでRunning+Ready条件を監視 | E-01 (行720-744) | ○ |
| C-17 | generateServiceでServiceを自動生成 | E-01 (行570-614) | ○ |
| C-18 | removeCreatedObjectsでPod/Service削除 | E-01 (行415-439) | ○ |
| C-19 | pre-attach logsの取得 | E-01 (行489-503) | ○ |
| C-20 | Pod失敗時の終了コード取得 | E-01 (行384-403) | ○ |
| C-21 | verifyImagePullPolicyでプルポリシー検証 | E-01 (行559-568) | ○ |
| C-22 | --privilegedによるPodSecurityの制約 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PodSecurityPolicy（非推奨）/ Pod Security Standardの制約はkubectl側ではなくAPI Server/Admission側で適用される
  - 候補：API Server Admission / Pod Security Admission / PodSecurityPolicy

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドフラグ、バリデーション、Pod生成ロジックはソースコードから直接確認済み
- 0: 低リスク - アタッチ・ウォッチ処理のフローはソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] イメージ名バリデーションの正規表現が最新か確認
- [ ] リスタートポリシーのデフォルト値が正しいか確認
- [ ] アタッチ→ログフォールバックのフローが正確か確認
