---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-kubectl_apply 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - ApplyFlags、ApplyOptions、NewCmdApply、ToOptions、Validate、Run、applyOneObject、saveLastApplyAnnotationIfNecessary、migrateToSSAIfNecessary
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.30の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.95, 94のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Flags -> Options パターン | E-01 (行60-79: ApplyFlags, 行82-142: ApplyOptions) | ○ |
| C-02 | CSAフィールドマネージャーは kubectl-client-side-apply | E-01 (行1093: `FieldManagerClientSideApply = "kubectl-client-side-apply"`) | ○ |
| C-03 | SSAフィールドマネージャーは kubectl | E-01 (行1098: `fieldManagerServerSideApply = "kubectl"`) | ○ |
| C-04 | 3つのサブコマンド（view/set/edit-last-applied） | E-01 (行218-220) | ○ |
| C-05 | Overwriteデフォルトtrue | E-01 (行190-191) | ○ |
| C-06 | OpenAPIPatchデフォルトtrue | E-01 (行191) | ○ |
| C-07 | SSA時はApplyPatchTypeでPatch | E-01 (行585-593) | ○ |
| C-08 | CSA新規はhelper.Create | E-01 (行699) | ○ |
| C-09 | CSA既存はPatcher.Patch | E-01 (行743) | ○ |
| C-10 | --force-conflicts は --server-side 必須 | E-01 (行391-393) | ○ |
| C-11 | --dry-run=client は SSA非対応 | E-01 (行395-397) | ○ |
| C-12 | --all と --selector は同時指定不可 | E-01 (行407-409) | ○ |
| C-13 | --prune は Alpha | E-01 (行152: "Alpha Disclaimer") | ○ |
| C-14 | --prune は SSA 非対応 | E-01 (行438-441) | ○ |
| C-15 | ContinueOnError がBuilder設定 | E-01 (行472) | ○ |
| C-16 | last-applied-configurationアノテーション管理 | E-01 (行687, 730-731) | ○ |
| C-17 | SSAマイグレーション（migrateToSSAIfNecessary） | E-01 (行905-980) | ○ |
| C-18 | last-applied-annotation保持（saveLastApplyAnnotationIfNecessary） | E-01 (行819-888) | ○ |
| C-19 | PostProcessorFnがpruneと出力を担当 | E-01 (行384, 1062-1086: PrintAndPrunePostProcessor) | ○ |
| C-20 | 削除中リソースへの変更警告 | E-01 (行175, 1130-1136: WarnIfDeleting) | ○ |
| C-21 | ApplySet（KEP-3659） | E-01 (行140-142, 行314-333) | ○ |
| C-22 | 関連機能No.95 Apply | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - 3-way merge の詳細はpatcher.goに委譲されるが、apply.goからの呼び出しは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] SSA/CSA の処理パス分岐が正しく記載されているか確認
- [ ] フィールドマネージャー名がコードと一致するか確認
- [ ] prune の制約条件（Alpha, SSA非対応等）が正しいか確認
- [ ] マイグレーションロジックの説明が正確か確認
- [ ] サブコマンド（view/set/edit-last-applied）の存在確認
