---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-kubectl patch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件の詳細**：Kubernetes RBAC仕様からの間接的推測
  2. **etcd更新仕様**：API Server内部実装の詳細は参照外
  3. **record機能の非推奨状態**：コード内コメントからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - patchコマンドメイン実装
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-05: `staging/src/k8s.io/apimachinery/pkg/types/patch.go` - PatchType定義（推定パス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | patchコマンドは3種のパッチタイプをサポート | E-01（行50: patchTypesマップ） | ○ |
| C-02 | デフォルトパッチタイプはstrategic | E-01（行139: "strategic"デフォルト, 行203） | ○ |
| C-03 | --patchと--patch-fileは排他的 | E-01（行182-184: Validateメソッド） | ○ |
| C-04 | --localフラグでローカルパッチ可能 | E-01（行142, 行247, 行287-307） | ○ |
| C-05 | --subresourceフラグでサブリソース対応 | E-01（行144, 行230, 行258） | ○ |
| C-06 | field-managerのデフォルト値は"kubectl-patch" | E-01（行143） | ○ |
| C-07 | パッチ結果は"patched"/"patched (no change)"で表示 | E-01（行352-357: patchOperation関数） | ○ |
| C-08 | YAML入力はJSONに変換される | E-01（行219: yaml.ToJSON呼び出し） | ○ |
| C-09 | resource.Builderでリソース情報を構築 | E-01（行224-233） | ○ |
| C-10 | helper.Patchでサーバーにリクエスト送信 | E-01（行259） | ○ |
| C-11 | reflect.DeepEqualで変更有無を判定 | E-01（行267） | ○ |
| C-12 | UnsupportedMediaTypeエラーハンドリング | E-01（行261-263） | ○ |
| C-13 | Strategic Merge Patchはカスタムリソース非対応 | E-01（行81-86: patchLong, 行342-343） | ○ |
| C-14 | パッチファイルはos.ReadFileで読み込み | E-01（行210-211） | ○ |
| C-15 | getPatchedJSONで3種パッチのローカル処理 | E-01（行318-350） | ○ |
| C-16 | 関連機能はNo.85とNo.1 | E-03（画面機能マッピング） | ○ |
| C-17 | 画面カテゴリはAdvanced Commands | E-02（画面一覧） | ○ |
| C-18 | RBAC patch権限が必要 | **根拠なし**（Kubernetes一般仕様からの推測） | △ |

## 4) 不足情報（Unknown / Missing）
- RBAC権限要件はKubernetes公式ドキュメントからの一般的知識に基づく推測であり、patchコマンド固有のコードでは直接確認できない
  - 候補：Kubernetes公式ドキュメント / API Server認可実装 / RBACテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドフラグ・パラメータの説明は全てソースコードで確認済み
- 0: 低リスク - エラーメッセージは全てソースコードから抽出
- 1: 中リスク - etcdへの更新仕様はAPI Server内部実装に依存するため、間接的な記述

## 6) レビュアーチェックリスト（最小）
- [ ] パッチタイプ3種の説明が正確か
- [ ] フラグ一覧がソースコードと一致しているか
- [ ] エラーメッセージがソースコードの文字列と完全一致するか
- [ ] コードリーディングガイドの行番号が最新ソースと合っているか
