---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-kubectl replace

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件（force時のdelete+create）**：間接的推測
  2. **grace-period=0の内部変換動作**：コード確認済みだが動作テスト未実施
  3. **etcd更新仕様**：API Server内部実装

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` - replaceコマンドメイン実装
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | replaceコマンドはPUT操作でリソース全体を置換 | E-01（行305: Helper.Replace） | ○ |
| C-02 | --forceで削除+再作成 | E-01（行315-423: forceReplace関数） | ○ |
| C-03 | --rawでRaw URI直接PUT | E-01（行256-261） | ○ |
| C-04 | ファイル指定は必須 | E-01（行228-229: Validate） | ○ |
| C-05 | grace-period=0は内部で1に変換 | E-01（行185-190） | ○ |
| C-06 | 強制削除のタイムアウトはデフォルト5分 | E-01（行354-357） | ○ |
| C-07 | 削除完了をポーリングで待機（1秒間隔） | E-01（行362） | ○ |
| C-08 | --dry-runと--forceは同時使用不可 | E-01（行224-226） | ○ |
| C-09 | field-managerのデフォルト値は"kubectl-replace" | E-01（行136） | ○ |
| C-10 | stdin入力時は一時ファイルに保存 | E-01（行317-332） | ○ |
| C-11 | --rawは単一ファイルのみ | E-01（行233-234） | ○ |
| C-12 | --rawはURLからの読み取り不可 | E-01（行236-238） | ○ |
| C-13 | CreateOrUpdateAnnotationで設定保存 | E-01（行286, 行396） | ○ |
| C-14 | 関連機能はNo.107とNo.1 | E-03 | ○ |
| C-15 | 画面カテゴリはAdvanced Commands | E-02 | ○ |
| C-16 | force時にdelete+create RBAC権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- force replace時のRBAC権限要件はKubernetes一般仕様に基づく推測
  - 候補：RBAC公式ドキュメント / API Serverテストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドフラグとエラーメッセージはソースコードで確認済み
- 1: 中リスク - force replaceの一時的リソース不在期間の影響は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] 通常replace/force replace/raw replaceの3パターンが正確に記述されているか
- [ ] エラーメッセージがソースコードの文字列と一致するか
- [ ] grace-period変換の動作説明が正確か
- [ ] コードリーディングガイドの行番号が最新ソースと合っているか
