---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 8
  claims_without_evidence: 2
confidence_derived: 0.80
---

# 根拠レポート：34-kubectl kustomize

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：8 / 10、根拠なし：2
- 優先レビュー（高）
  1. **Kustomize build内部処理の詳細**：外部パッケージに委譲されており直接確認していない
  2. **Kustomize buildのフラグ一覧**：外部パッケージで定義されるフラグの完全な一覧が不明
  3. **エラーメッセージ詳細**：Kustomize側で生成されるエラーメッセージの完全な一覧が不明

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/kustomize/kustomize.go` - kustomizeコマンドアダプター
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kustomize buildのkubctlアダプターである | E-01（行30-41: NewCmdKustomize） | ○ |
| C-02 | MakeHelpでkubectl用ヘルプ生成 | E-01（行31） | ○ |
| C-03 | NewCmdBuildでビルドコマンド生成 | E-01（行32） | ○ |
| C-04 | MakeFsOnDiskでディスクファイルシステム使用 | E-01（行33） | ○ |
| C-05 | streams.Outに出力 | E-01（行40） | ○ |
| C-06 | i18n.Tでヘルプ文字列を国際化 | E-01（行37-38） | ○ |
| C-07 | 関連機能はNo.82 | E-03 | ○ |
| C-08 | 画面カテゴリはAdvanced Commands | E-02 | ○ |
| C-09 | Kustomize buildの内部処理詳細（base/overlay） | **根拠なし**（外部パッケージ未確認） | △ |
| C-10 | API Server接続不要 | **根拠なし**（ソースコードにREST呼び出しが無いことからの推測） | △ |

## 4) 不足情報（Unknown / Missing）
- Kustomize build内部処理の詳細はvendorパッケージに委譲されており直接確認していない
  - 候補：`vendor/sigs.k8s.io/kustomize/` / Kustomize公式ドキュメント
- kubectl kustomizeの追加フラグはbuildパッケージ側で定義される
  - 候補：`vendor/sigs.k8s.io/kustomize/kustomize/v5/commands/build/`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 処理の大部分が外部パッケージに委譲されており、詳細な動作確認が困難
- 0: 低リスク - kubectl側のアダプターコードは42行と非常に短く、明確

## 6) レビュアーチェックリスト（最小）
- [ ] Kustomize buildの追加フラグが漏れていないか（外部パッケージを確認）
- [ ] Kustomize v5のbuild動作が正確に記述されているか
- [ ] エラーメッセージがKustomize側の実装と整合しているか
