---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：35-kubectl label

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件**：patch/get権限の使い分け
  2. **MergePatch生成失敗時のフォールバック動作**：コード確認済みだが条件の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/label/label.go` - labelコマンドメイン実装
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ラベルの追加・変更・削除をサポート | E-01（行416-441: parseLabels, 行443-480: labelFunc） | ○ |
| C-02 | --overwriteでの上書き制御 | E-01（行155, 行406-414: validateNoOverwrites） | ○ |
| C-03 | --listでラベル一覧表示 | E-01（行156, 行363-383） | ○ |
| C-04 | 操作結果メッセージは4種（labeled/unlabeled/modified/not labeled） | E-01（行49-54, 行393-404） | ○ |
| C-05 | parseLabelsでKEY=VALUE/KEY-をパース | E-01（行416-441） | ○ |
| C-06 | 同一キーの追加と削除は同時不可 | E-01（行435-439） | ○ |
| C-07 | ラベル値バリデーション実行 | E-01（行425-427: IsValidLabelValue） | ○ |
| C-08 | --resource-versionは単一リソースのみ | E-01（行272-274） | ○ |
| C-09 | --allと--selectorは同時使用不可 | E-01（行220-222） | ○ |
| C-10 | field-managerのデフォルト値は"kubectl-label" | E-01（行165） | ○ |
| C-11 | MergePatch生成失敗時にReplaceフォールバック | E-01（行337-356） | ○ |
| C-12 | label not foundメッセージ表示 | E-01（行316-318） | ○ |
| C-13 | --listと--outputは同時使用不可 | E-01（行204-206） | ○ |
| C-14 | ラベルキーは最大63文字 | E-01（行98-99: labelLong） | ○ |
| C-15 | DNSサブドメインプレフィックス対応 | E-01（行99） | ○ |
| C-16 | 関連機能はNo.95とNo.1 | E-03 | ○ |
| C-17 | 画面カテゴリはSettings Commands | E-02 | ○ |
| C-18 | RBAC patch/get権限の使い分け | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RBAC権限要件の詳細はKubernetes一般仕様に基づく推測
  - 候補：Kubernetes公式ドキュメント / API Server認可テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フラグ、エラーメッセージ、操作メッセージは全てソースコードで確認済み
- 0: 低リスク - ラベルパースロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] エラーメッセージがソースコードの文字列と一致するか
- [ ] 操作結果メッセージ4種が正確に記述されているか
- [ ] ラベルバリデーション仕様が正確か
- [ ] コードリーディングガイドの行番号が最新ソースと合っているか
