---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：36-kubectl annotate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件**：patch権限の要否

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/annotate/annotate.go` - annotateコマンドメイン実装
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アノテーションの追加・変更・削除をサポート | E-01（行457-485: updateAnnotations） | ○ |
| C-02 | --overwriteでの上書き制御 | E-01（行183, 行436-454: validateNoAnnotationOverwrites） | ○ |
| C-03 | change-causeアノテーションは常に上書き可能 | E-01（行440-441） | ○ |
| C-04 | --listでアノテーション一覧表示 | E-01（行184, 行386-406） | ○ |
| C-05 | Flags -> Options の2段階変換パターン | E-01（行52-70: AnnotateFlags, 行82-111: AnnotateOptions, 行193: ToOptions） | ○ |
| C-06 | MergePatch生成失敗時にReplaceフォールバック | E-01（行361-380） | ○ |
| C-07 | 同一キーの追加と削除は同時不可 | E-01（行418-433: validateAnnotations） | ○ |
| C-08 | --resource-versionは単一リソースのみ | E-01（行317-319） | ○ |
| C-09 | field-managerのデフォルト値は"kubectl-annotate" | E-01（行180） | ○ |
| C-10 | --allと--selectorは同時使用不可 | E-01（行254-255） | ○ |
| C-11 | --listと--outputは同時使用不可 | E-01（行251-253） | ○ |
| C-12 | アノテーションにはラベルのような値長さ制限がない | E-01（記載なし - ラベルと異なりバリデーション呼び出しがないことで確認） | ○ |
| C-13 | 関連機能はNo.96とNo.1 | E-03 | ○ |
| C-14 | 画面カテゴリはSettings Commands | E-02 | ○ |
| C-15 | RBAC patch権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RBAC権限要件はKubernetes一般仕様に基づく推測
  - 候補：Kubernetes公式ドキュメント / API Server認可テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フラグ、エラーメッセージはソースコードで確認済み
- 0: 低リスク - labelコマンドとの類似性が高く、パターンが確立されている

## 6) レビュアーチェックリスト（最小）
- [ ] change-causeアノテーションの特別扱いが正確に記述されているか
- [ ] エラーメッセージがソースコードの文字列と一致するか
- [ ] labelコマンドとの差異が正確に反映されているか
- [ ] コードリーディングガイドの行番号が最新ソースと合っているか
