---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：40-kubectl version

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **バージョンスキュー警告の詳細条件**：skew_warning.goを別途確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` - versionコマンドメイン実装
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/version/skew_warning.go` - スキュー警告（ファイル存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クライアント・サーバー・Kustomizeの3種のバージョンを表示 | E-01（行42-46: Version構造体, 行134-135, 行140） | ○ |
| C-02 | --clientフラグでクライアントのみ表示 | E-01（行89, 行100-102, 行137） | ○ |
| C-03 | --output は yaml / json のみ | E-01（行90, 行120-122） | ○ |
| C-04 | version.Get()でクライアントバージョン取得 | E-01（行134） | ○ |
| C-05 | debug.ReadBuildInfoでKustomizeバージョン取得 | E-01（行190-201） | ○ |
| C-06 | Kustomizeバージョンのハードコード値はv5.7.1 | E-01（行39） | ○ |
| C-07 | discoveryClient.Invalidate()でキャッシュ無効化 | E-01（行139） | ○ |
| C-08 | discoveryClient.ServerVersion()でサーバーバージョン取得 | E-01（行140） | ○ |
| C-09 | テキスト/yaml/json出力の3パターン | E-01（行143-166） | ○ |
| C-10 | サーバーバージョン取得エラーは最後に返される | E-01（行180） | ○ |
| C-11 | kubeconfig未設定時はDiscoveryClientがnil | E-01（行106-108） | ○ |
| C-12 | 余分な引数のチェック | E-01（行116-118） | ○ |
| C-13 | warnings-as-errorsフラグ対応 | E-01（行98, 行174-175） | ○ |
| C-14 | 関連機能はNo.1 | E-03 | ○ |
| C-15 | 画面カテゴリはOther Commands | E-02 | ○ |
| C-16 | バージョンスキュー警告の詳細条件 | **根拠なし**（skew_warning.goの内容未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- バージョンスキュー警告の具体的な条件（何マイナーバージョン差で警告するか等）はskew_warning.goの確認が必要
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/version/skew_warning.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メインのバージョン表示ロジックは全てソースコードで確認済み
- 1: 中リスク - バージョンスキュー警告の詳細は別ファイルに依存

## 6) レビュアーチェックリスト（最小）
- [ ] Version構造体のJSON/YAMLタグが正確か
- [ ] 出力形式3パターンが正確に記述されているか
- [ ] Kustomizeバージョンのフォールバック値が正確か
- [ ] skew_warning.goの警告条件を確認する必要があるか判断
- [ ] コードリーディングガイドの行番号が最新ソースと合っているか
