---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-kubectl_explain 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **CRDフィールド表示の動作詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` - 主要ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.5の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIリソースのフィールド構造とドキュメントを表示 | E-01 (行37-45: explainLong) | ○ |
| C-02 | OpenAPI v2/v3から情報を取得 | E-01 (行200-230: Run) | ○ |
| C-03 | デフォルト出力フォーマットはplaintext | E-01 (行65, 83) | ○ |
| C-04 | --recursiveで再帰的表示 | E-01 (行90, 226) | ○ |
| C-05 | --api-versionでAPIバージョン指定 | E-01 (行91, 212-219) | ○ |
| C-06 | plaintext-openapiv2でv2レンダラー使用 | E-01 (行66, 201-202) | ○ |
| C-07 | v3利用不可時はv2にフォールバック | E-01 (行205-208) | ○ |
| C-08 | 引数は1つのみ受付 | E-01 (行169-176) | ○ |
| C-09 | リソースタイプ未指定時のエラーメッセージ | E-01 (行170) | ○ |
| C-10 | SplitAndParseResourceRequestでリソースとフィールドパスを分離 | E-01 (行185, 193) | ○ |
| C-11 | renderOpenAPIV2でv2スキーマ取得 | E-01 (行232-264) | ○ |
| C-12 | LookupResourceでスキーマ検索 | E-01 (行258) | ○ |
| C-13 | openapiv3explain.PrintModelDescriptionでv3出力 | E-01 (行221-228) | ○ |
| C-14 | 主機能はexplain、機能No.110 | E-03 | ○ |
| C-15 | OpenAPI仕様公開（機能No.6）とAPI連携 | E-03 | ○ |
| C-16 | CRDフィールドも表示可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CRDのフィールドがOpenAPI仕様に含まれるかはCRD定義の設定に依存する。kubectl explain側のコードからはCRD固有の処理は確認できず、OpenAPI仕様にスキーマが含まれていれば表示される動作
  - 候補：CRD定義のOpenAPIV3Schema設定 / API Server側のOpenAPI仕様生成

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドフラグ、バリデーション、v2/v3分岐はソースコードから確認済み
- 1: 中リスク - CRD対応の詳細はAPI Server側に依存

## 6) レビュアーチェックリスト（最小）
- [ ] v3/v2フォールバックロジックが正確か確認
- [ ] 出力フォーマット（plaintext / plaintext-openapiv2）の違いを確認
- [ ] SplitAndParseResourceRequestのロジックが正しいか確認
