---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：6-kubectl_get 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **サーバーサイドTable変換の詳細動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` - 主要ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.6の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リソース一覧や詳細を取得・表示する | E-01 (行88-97: getLong) | ○ |
| C-02 | デフォルトチャンクサイズは500 | E-01 (行154: cmdutil.DefaultChunkSize) | ○ |
| C-03 | ServerPrintデフォルトtrue | E-01 (行155) | ○ |
| C-04 | --rawモードでrawhttp.RawGet呼び出し | E-01 (行444-449) | ○ |
| C-05 | --watchモードでwatch()メソッド呼び出し | E-01 (行451-453) | ○ |
| C-06 | ソート指定時はチャンクサイズ0 | E-01 (行456-460) | ○ |
| C-07 | resource.Builderでリソース取得 | E-01 (行462-475) | ○ |
| C-08 | RuntimeSorterでソート | E-01 (行502-508) | ○ |
| C-09 | watch()でresourceVersion "0"から開始 | E-01 (行649) | ○ |
| C-10 | transformRequestsでAcceptヘッダをTable形式に設定 | E-01 (行424-439) | ○ |
| C-11 | --rawと引数の排他制約 | E-01 (行198-203) | ○ |
| C-12 | --rawと--outputの排他制約 | E-01 (行303-305: Validate) | ○ |
| C-13 | --show-labelsの出力フォーマット制約 | E-01 (行310-315: Validate) | ○ |
| C-14 | --output-watch-eventsは--watchと共に使用 | E-01 (行316-318: Validate) | ○ |
| C-15 | ウォッチ時にsort-byの警告表示 | E-01 (行274-276) | ○ |
| C-16 | リソース未指定時のエラーメッセージ | E-01 (行282-291) | ○ |
| C-17 | printGenericで非テーブル形式出力 | E-01 (行714-805) | ○ |
| C-18 | trackingWriterWrapperで出力有無を追跡 | E-01 (行577-585) | ○ |
| C-19 | "No resources found"メッセージ | E-01 (行566-573) | ○ |
| C-20 | multipleGVKsRequestedで複数リソースタイプ判定 | E-01 (行815-826) | ○ |
| C-21 | 主機能はリソース取得（get）、機能No.80 | E-03 | ○ |
| C-22 | サーバーサイドTable変換の仕組み | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サーバーサイドTable変換はAPI Server側の実装であり、kubectlからはAcceptヘッダの設定のみ確認可能
  - 候補：API Server Table変換ロジック / CRDのadditionalPrinterColumns

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フラグ定義、バリデーション、主要処理フローはソースコードから確認済み
- 1: 中リスク - サーバーサイドTable変換の詳細はAPI Server側に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 出力フォーマット一覧が最新と一致するか確認
- [ ] チャンクサイズのデフォルト値が正しいか確認
- [ ] ウォッチモードのresourceVersion開始値が正確か確認
- [ ] プリンターチェーンの構築ロジックが正確か確認
