---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：8-kubectl_delete 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Garbage Collectorの詳細動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` - 主要ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.8の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル名、stdin、リソース名、ラベルセレクタで削除 | E-01 (行46-49: deleteLong) | ○ |
| C-02 | グレースフル削除のデフォルト猶予期間 | E-01 (行51-58: deleteLong) | ○ |
| C-03 | 強制削除時の警告 | E-01 (行60-69: deleteLong) | ○ |
| C-04 | --nowと--grace-periodは排他的 | E-01 (行186-189: Complete) | ○ |
| C-05 | grace-period=0はforce未指定時にgrace-period=1に変換 | E-01 (行191-195: Complete) | ○ |
| C-06 | --forceかつgrace-period未指定でgrace-period=0 | E-01 (行196-198: Complete) | ○ |
| C-07 | --allと--selectorは排他的 | E-01 (行274-275: Validate) | ○ |
| C-08 | --allと--field-selectorは排他的 | E-01 (行277-278: Validate) | ○ |
| C-09 | --forceかつgrace-period=0で即時削除警告 | E-01 (行285-286: Validate) | ○ |
| C-10 | --forceかつgrace-period>0はエラー | E-01 (行287-288: Validate) | ○ |
| C-11 | --rawモードでrawhttp.RawDelete呼び出し | E-01 (行320-329: RunDelete) | ○ |
| C-12 | --interactiveモードで確認プロンプト | E-01 (行331-361: RunDelete) | ○ |
| C-13 | confirmation()でy/N入力を受付 | E-01 (行529-548) | ○ |
| C-14 | "deletion is cancelled"メッセージ | E-01 (行358) | ○ |
| C-15 | DeleteResult()でVisitパターンによる個別削除 | E-01 (行366-477) | ○ |
| C-16 | deleteResource()でresource.NewHelper().DeleteWithOptions() | E-01 (行479-492) | ○ |
| C-17 | --waitでcmdwait.WaitOptions.RunWait() | E-01 (行459-476) | ○ |
| C-18 | ウォッチ権限不足時はスキップして正常終了 | E-01 (行470-475) | ○ |
| C-19 | クラスタスコープリソース削除時の警告 | E-01 (行399-402) | ○ |
| C-20 | PrintObj()で削除結果を出力 | E-01 (行496-527) | ○ |
| C-21 | -o nameで<type>/<name>形式出力 | E-01 (行519-522) | ○ |
| C-22 | --interactiveと--rawは排他的 | E-01 (行295-297: Validate) | ○ |
| C-23 | 主機能はリソース削除（delete）、機能No.83 | E-03 | ○ |
| C-24 | Garbage Collectorによるカスケード削除の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Garbage Collectorコントローラーの詳細動作はkube-controller-manager側の実装であり、kubectlからは確認不可
  - 候補：`pkg/controller/garbagecollector/` / kube-controller-manager

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 削除フラグ、バリデーション、削除処理はソースコードから直接確認済み
- 0: 低リスク - grace-period変換ロジックはソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] grace-period変換ロジック（0→1、--force時は0）が正確か確認
- [ ] --interactiveの確認プロンプトの動作が正確か確認
- [ ] カスケード削除戦略のオプション値が最新か確認
- [ ] エラーメッセージが網羅的か確認
