---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：9-kubectl_rollout 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **各サブコマンドの詳細実装**：個別サブコマンドファイル未精読
  2. **restartedAtアノテーションの仕組み**：サブコマンド実装の確認が必要
  3. **Deploymentコントローラーとの連携**：controller-manager側の実装

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` - 親コマンド
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.9の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - rolloutサブコマンド階層

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6つのサブコマンド（history, pause, restart, resume, status, undo） | E-01 (行67-73), E-04 | ○ |
| C-02 | 対象リソースはdeployments, daemonsets, statefulsets | E-01 (行47-53: rolloutValidResources) | ○ |
| C-03 | rolloutLongの説明文 | E-01 (行31-32) | ○ |
| C-04 | rolloutExampleにundo, status, restart, selectorの例 | E-01 (行34-45) | ○ |
| C-05 | DefaultSubCommandRunで親コマンドのみ時はヘルプ表示 | E-01 (行64) | ○ |
| C-06 | NewCmdRolloutHistory | E-01 (行67) | ○ |
| C-07 | NewCmdRolloutPause | E-01 (行68) | ○ |
| C-08 | NewCmdRolloutResume | E-01 (行69) | ○ |
| C-09 | NewCmdRolloutUndo | E-01 (行70) | ○ |
| C-10 | NewCmdRolloutStatus | E-01 (行71) | ○ |
| C-11 | NewCmdRolloutRestart | E-01 (行72) | ○ |
| C-12 | 主機能はロールアウト管理（rollout）、機能No.90 | E-03 | ○ |
| C-13 | Deploymentコントローラー（機能No.7）との連携 | E-03 | ○ |
| C-14 | ReplicaSetコントローラー（機能No.8）との連携 | E-03 | ○ |
| C-15 | rollout restartのアノテーション更新メカニズム | E-04 | ○ |
| C-16 | 各サブコマンドの詳細入出力項目 | **根拠なし** | △ |
| C-17 | restartedAtアノテーションの具体的なキー名 | **根拠なし** | △ |
| C-18 | Deploymentコントローラーのローリングアップデート制御詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各サブコマンドの詳細実装は個別ファイル（rollout_status.go等）の精読が必要
  - 候補：`rollout_status.go` / `rollout_undo.go` / `rollout_restart.go`
- restartedAtアノテーションのキー名はrollout_restart.goで確認が必要
  - 候補：`rollout_restart.go`
- Deploymentコントローラーの動作はkube-controller-manager側の実装
  - 候補：`pkg/controller/deployment/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 6つのサブコマンドの存在はソースコードから確認済み
- 0: 低リスク - 対象リソースタイプはソースコードから確認済み
- 1: 中リスク - 各サブコマンドの詳細動作は概要レベルの確認
- 2: 高リスク - restartedAtアノテーションのキー名は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] 各サブコマンドの入出力項目が正確か、個別ファイルと照合して確認
- [ ] restartedAtアノテーションのキー名が正確か確認
- [ ] rollout pauseがDeploymentのみ有効かの記述を確認
- [ ] ロールバック時のリビジョン情報の格納先を確認
