---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 116
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：116 / 120、根拠なし：4
- 優先レビュー（高）
  1. **IT-115（ConfigMap CRUD）**：テストファイルのディレクトリのみ参照、具体的テスト関数名が未確認
  2. **IT-118（PodGC）**：テストファイルのディレクトリのみ参照、具体的テスト関数名が未確認
  3. **IT-116（Endpoints Controller）**：テストファイル参照はあるが、テスト手順の詳細が概要レベル
  4. **IT-117（ServiceCIDR Migration）**：マイグレーションテストの具体的な手順が概要レベル

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `test/integration/apiserver/apiserver_test.go` - APIサーバー結合テスト
- E-02: `test/integration/auth/auth_test.go` - 認証・認可結合テスト
- E-03: `test/integration/auth/rbac_test.go` - RBAC結合テスト
- E-04: `test/integration/scheduler/scheduler_test.go` - スケジューラ結合テスト
- E-05: `test/integration/deployment/deployment_test.go` - Deployment結合テスト
- E-06: `test/integration/statefulset/statefulset_test.go` - StatefulSet結合テスト
- E-07: `test/integration/daemonset/daemonset_test.go` - DaemonSet結合テスト
- E-08: `test/integration/job/job_test.go` - Job結合テスト
- E-09: `test/integration/cronjob/cronjob_test.go` - CronJob結合テスト
- E-10: `test/integration/garbagecollector/garbage_collector_test.go` - GC結合テスト
- E-11: `test/integration/garbagecollector/cluster_scoped_owner_test.go` - クラスタスコープOwnerテスト
- E-12: `test/integration/etcd/etcd_storage_path_test.go` - etcdストレージパステスト
- E-13: `test/integration/controlplane/transformation/secrets_transformation_test.go` - Secrets暗号化テスト
- E-14: `test/integration/controlplane/transformation/kmsv2_transformation_test.go` - KMSv2テスト
- E-15: `test/integration/controlplane/transformation/kms_transformation_test.go` - KMSテスト
- E-16: `test/integration/endpointslice/endpointslice_test.go` - EndpointSliceテスト
- E-17: `test/integration/endpointslice/endpointsliceterminating_test.go` - EndpointSlice Terminatingテスト
- E-18: `test/integration/endpointslice/endpointslicemirroring_test.go` - EndpointSlice Mirroringテスト
- E-19: `test/integration/service/service_test.go` - Service結合テスト
- E-20: `test/integration/service/loadbalancer_test.go` - LoadBalancer結合テスト
- E-21: `test/integration/network/services_test.go` - ネットワークService結合テスト
- E-22: `test/integration/namespace/ns_conditions_test.go` - Namespace結合テスト
- E-23: `test/integration/certificates/` - 証明書関連テスト群
- E-24: `test/integration/quota/quota_test.go` - ResourceQuotaテスト
- E-25: `test/integration/pods/pods_test.go` - Pod結合テスト
- E-26: `test/integration/evictions/evictions_test.go` - Evictionテスト
- E-27: `test/integration/controlplane/crd_test.go` - CRDコントロールプレーンテスト
- E-28: `test/integration/controlplane/kube_apiserver_test.go` - APIサーバーテスト
- E-29: `test/integration/controlplane/graceful_shutdown_test.go` - Graceful Shutdownテスト
- E-30: `test/integration/controlplane/apiserver_identity_test.go` - APIサーバーIdentityテスト
- E-31: `test/integration/controlplane/audit/audit_test.go` - 監査テスト
- E-32: `test/integration/metrics/metrics_test.go` - メトリクステスト
- E-33: `test/integration/volumescheduling/volume_binding_test.go` - VolumeBind結合テスト
- E-34: `test/integration/volumescheduling/storage_capacity_scoring_test.go` - StorageCapacityスコアリング
- E-35: `test/integration/secrets/secrets_test.go` - Secretsテスト
- E-36: `test/integration/dryrun/dryrun_test.go` - DryRunテスト
- E-37: `test/integration/serviceaccount/service_account_test.go` - ServiceAccountテスト
- E-38: `test/integration/serviceaccount/external_jwt_signer_test.go` - 外部JWTサイナーテスト
- E-39: `test/integration/serviceaccount/legacy_service_account_token_clean_up_test.go` - レガシーSAトークンクリーンアップテスト
- E-40: `test/integration/replicationcontroller/replicationcontroller_test.go` - RCテスト
- E-41: `test/integration/dra/dra_test.go` - DRAテスト
- E-42: `test/integration/controlplane/synthetic_controlplane_test.go` - コントロールプレーンテスト
- E-43: `test/integration/defaulttolerationseconds/defaulttolerationseconds_test.go` - デフォルトToleration
- E-44: `test/integration/endpoints/endpoints_test.go` - Endpointsテスト
- E-45: `test/integration/servicecidr/migration_test.go` - ServiceCIDRマイグレーション
- E-46: `test/integration/configmap/` - ConfigMapテストディレクトリ
- E-47: `test/integration/podgc/` - PodGCテストディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: APIサーバーへのPod CRUD | E-25 | ○ |
| C-02 | IT-002: リストチャンキング | E-01 | ○ |
| C-03 | IT-003: ラベルセレクタ付きチャンキング | E-01 | ○ |
| C-04 | IT-004: Watch基本動作 | E-42 | ○ |
| C-05 | IT-005: 不正Patch 4xxレスポンス | E-01 | ○ |
| C-06 | IT-006: メタデータクライアント | E-01 | ○ |
| C-07 | IT-007: CRD Protobuf | E-01 | ○ |
| C-08 | IT-008: サブリソースTable形式 | E-01 | ○ |
| C-09 | IT-009: Watch Transformキャッシュ | E-01 | ○ |
| C-10 | IT-010: DryRun操作 | E-36 | ○ |
| C-11 | IT-011: AlwaysAllowモード | E-02 | ○ |
| C-12 | IT-012: AlwaysDenyモード | E-02 | ○ |
| C-13 | IT-013: 認証済みユーザーアクセス | E-02 | ○ |
| C-14 | IT-014: 未認証ユーザー拒否 | E-02 | ○ |
| C-15 | IT-015: 権限不足ユーザー拒否 | E-02 | ○ |
| C-16 | IT-016: Impersonate権限制御 | E-02 | ○ |
| C-17 | IT-017: UID付きImpersonate | E-02 | ○ |
| C-18 | IT-018: 制約付きImpersonation | E-02 | ○ |
| C-19 | IT-019: RBACポリシー | E-03 | ○ |
| C-20 | IT-020: ブートストラップロール | E-03 | ○ |
| C-21 | IT-021: Namespace認可 | E-02 | ○ |
| C-22 | IT-022: リソース種別認可 | E-02 | ○ |
| C-23 | IT-023: 読み取り専用認可 | E-02 | ○ |
| C-24 | IT-024: Webhook認証 | E-02 | ○ |
| C-25 | IT-025: SA自動作成 | E-37 | ○ |
| C-26 | IT-026: SAトークン自動マウント | E-37 | ○ |
| C-27 | IT-027: SAトークン認証 | E-37 | ○ |
| C-28 | IT-028: レガシーSAトークン追跡 | E-37 | ○ |
| C-29 | IT-029: レガシーSAトークンクリーンアップ | E-39 | ○ |
| C-30 | IT-030: 外部JWTサイナー | E-38 | ○ |
| C-31 | IT-031: Unschedulableノード | E-04 | ○ |
| C-32 | IT-032: 複数スケジューラ | E-04 | ○ |
| C-33 | IT-033: 複数プロファイル | E-04 | ○ |
| C-34 | IT-034: Allocatable考慮 | E-04 | ○ |
| C-35 | IT-035: スケジューラInformer | E-04 | ○ |
| C-36 | IT-036: ノードイベント再試行 | E-04 | ○ |
| C-37 | IT-037: HostPort競合 | E-04 | ○ |
| C-38 | IT-038: Taint/Toleration結合 | E-04 | ○ |
| C-39 | IT-039: 新規Deployment | E-05 | ○ |
| C-40 | IT-040: Rolling Update | E-05 | ○ |
| C-41 | IT-041: セレクタ不変性 | E-05 | ○ |
| C-42 | IT-042: 一時停止Deployment | E-05 | ○ |
| C-43 | IT-043: 一時停止スケール | E-05 | ○ |
| C-44 | IT-044: Hash衝突処理 | E-05 | ○ |
| C-45 | IT-045: 失敗Deployment | E-05 | ○ |
| C-46 | IT-046: スケールサブリソース | E-05 | ○ |
| C-47 | IT-047: RS Orphaning/Adoption | E-05 | ○ |
| C-48 | IT-048: StatefulSetレプリカ変更 | E-06 | ○ |
| C-49 | IT-049: StatefulSet可用性 | E-06 | ○ |
| C-50 | IT-050: StatefulSet Pod失敗 | E-06 | ○ |
| C-51 | IT-051: StartOrdinal | E-06 | ○ |
| C-52 | IT-052: DS 1ノードPod起動 | E-07 | ○ |
| C-53 | IT-053: DS 複数ノードPod | E-07 | ○ |
| C-54 | IT-054: DS NodeSelector | E-07 | ○ |
| C-55 | IT-055: DS Taint処理 | E-07 | ○ |
| C-56 | IT-056: DS Rolling Update | E-07 | ○ |
| C-57 | IT-057: 非並列Job | E-08 | ○ |
| C-58 | IT-058: 並列Job | E-08 | ○ |
| C-59 | IT-059: 並列数変更 | E-08 | ○ |
| C-60 | IT-060: IndexedJob | E-08 | ○ |
| C-61 | IT-061: Pod失敗ポリシー | E-08 | ○ |
| C-62 | IT-062: 成功ポリシー | E-08 | ○ |
| C-63 | IT-063: BackoffLimitPerIndex | E-08 | ○ |
| C-64 | IT-064: Job一時停止/再開 | E-08 | ○ |
| C-65 | IT-065: Pod置換ポリシー | E-08 | ○ |
| C-66 | IT-066: ManagedBy | E-08 | ○ |
| C-67 | IT-067: CronJob実行/クリーンアップ | E-09 | ○ |
| C-68 | IT-068: RC レプリカ管理 | E-40 | ○ |
| C-69 | IT-069: カスケード削除 | E-10 | ○ |
| C-70 | IT-070: Orphaning | E-10 | ○ |
| C-71 | IT-071: 存在しないOwner | E-10 | ○ |
| C-72 | IT-072: CR カスケード削除 | E-10 | ○ |
| C-73 | IT-073: CRD削除カスケード | E-10 | ○ |
| C-74 | IT-074: クラスタスコープOwner | E-11 | ○ |
| C-75 | IT-075: etcdストレージパス | E-12 | ○ |
| C-76 | IT-076: エミュレーションStorageVersion | E-01 | ○ |
| C-77 | IT-077: Secrets暗号化 | E-13 | ○ |
| C-78 | IT-078: KMSv2プロバイダー | E-14 | ○ |
| C-79 | IT-079: KMSプロバイダー | E-15 | ○ |
| C-80 | IT-080: 暗号化ホットリロード | E-15 | ○ |
| C-81 | IT-081: KMSv2 Healthz | E-14 | ○ |
| C-82 | IT-082: EndpointSlice生成 | E-16 | ○ |
| C-83 | IT-083: EndpointSlice Terminating | E-17 | ○ |
| C-84 | IT-084: EndpointSlice Mirroring | E-18 | ○ |
| C-85 | IT-085: ExternalName ITP | E-19 | ○ |
| C-86 | IT-086: LB NodePort無効化 | E-20 | ○ |
| C-87 | IT-087: LB IPMode | E-20 | ○ |
| C-88 | IT-088: ServiceフィナライザRepair | E-21 | ○ |
| C-89 | IT-089: ServiceCIDR 28bit | E-21 | ○ |
| C-90 | IT-090: Namespace削除条件 | E-22 | ○ |
| C-91 | IT-091: Namespaceラベル自動設定 | E-22 | ○ |
| C-92 | IT-092: CSR Field Selector | E-23 | ○ |
| C-93 | IT-093: CSR自動承認 | E-23 | ○ |
| C-94 | IT-094: CSR期間設定 | E-23 | ○ |
| C-95 | IT-095: ResourceQuota適用 | E-24 | ○ |
| C-96 | IT-096: 制限リソース拒否 | E-24 | ○ |
| C-97 | IT-097: Serviceクォータ | E-24 | ○ |
| C-98 | IT-098: Podトポロジーラベル | E-25 | ○ |
| C-99 | IT-099: ActiveDeadlineSeconds | E-25 | ○ |
| C-100 | IT-100: EphemeralContainer | E-25 | ○ |
| C-101 | IT-101: Podリサイズ | E-25 | ○ |
| C-102 | IT-102: Eviction API | E-26 | ○ |
| C-103 | IT-103: CRD作成 | E-27 | ○ |
| C-104 | IT-104: CRD OpenAPI | E-27 | ○ |
| C-105 | IT-105: CRD Shadowグループ | E-27 | ○ |
| C-106 | IT-106: Livez/Readyz | E-28 | ○ |
| C-107 | IT-107: Graceful Shutdown | E-29 | ○ |
| C-108 | IT-108: Identity Lease | E-30 | ○ |
| C-109 | IT-109: リースGC | E-30 | ○ |
| C-110 | IT-110: 監査ログ | E-31 | ○ |
| C-111 | IT-111: メトリクス | E-32 | ○ |
| C-112 | IT-112: VolumeBinding | E-33 | ○ |
| C-113 | IT-113: StorageCapacityスコアリング | E-34 | ○ |
| C-114 | IT-114: Secrets CRUD | E-35 | ○ |
| C-115 | IT-115: ConfigMap CRUD | E-46 | △ |
| C-116 | IT-116: Endpoints Controller | E-44 | △ |
| C-117 | IT-117: ServiceCIDR Migration | E-45 | △ |
| C-118 | IT-118: PodGC | E-47 | △ |
| C-119 | IT-119: DefaultTolerationSeconds | E-43 | ○ |
| C-120 | IT-120: DRA | E-41 | ○ |

## 4) 不足情報（Unknown / Missing）
- IT-115（ConfigMap CRUD）：ConfigMapのテストディレクトリは存在するが、具体的なテスト関数の内容を詳細に確認していない
  - 候補：`test/integration/configmap/` 内の個別テストファイル確認
- IT-116（Endpoints Controller）：テストファイルは確認したが、テスト手順の詳細記述が概要レベル
  - 候補：`test/integration/endpoints/endpoints_test.go` のテスト関数詳細確認
- IT-117（ServiceCIDR Migration）：マイグレーションテストの具体的な手順が概要レベルにとどまる
  - 候補：`test/integration/servicecidr/migration_test.go` の詳細確認
- IT-118（PodGC）：PodGCテストディレクトリは存在するが、具体的なテスト関数名が未確認
  - 候補：`test/integration/podgc/` 内の個別テストファイル確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大多数のテストケース（116件）はソースコード上の実際のテスト関数と1対1で対応しており信頼度が高い
- 1: 中リスク - テストケースの期待結果および前提条件は、テスト関数のシグネチャとコメントから推定しており、テスト本体の詳細ロジックまで全て追跡していない
- 1: 中リスク - Kubernetesは大規模プロジェクトであり、`test/integration/` 配下の全テストを網羅しきれていない可能性がある（例：admissionwebhook, flowcontrol, oidc, openapi等の領域は本一覧に含まれていない）
- 0: 低リスク - テスト種別の分類（API連携/コンポーネント間連携/データベース連携）は、テストコードの依存パッケージとテスト対象から妥当に判断

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）がプロジェクトのテスト方針と一致しているか
- [ ] △印のテストケース（IT-115, IT-116, IT-117, IT-118）の内容を実際のソースコードと照合し正確性を確認
- [ ] 本一覧に含まれていない結合テスト領域（admissionwebhook, flowcontrol, oidc, openapi, tracing等）がプロジェクト要件上必要かどうかを判断
- [ ] テスト手順の記載粒度がプロジェクトのテスト計画で求められるレベルと一致しているか
- [ ] 外部サービス連携テスト（Webhook認証, 外部JWTサイナー, KMS）の前提条件が実環境で再現可能か確認
