---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 135
  claims_with_evidence: 131
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：131 / 135、根拠なし：4
- 優先レビュー（高）
  1. **No.61 WaitForFirstConsumer**：定数は存在するが発行箇所の直接確認が不足
  2. **No.62 WaitForPodScheduled**：定数は存在するが発行箇所の直接確認が不足
  3. **No.63 ExternalExpanding**：定数は存在するが発行箇所の直接確認が不足
  4. **No.134 HealthCheckNodePort**：EventRecorderの利用は確認したが具体的なEvent Reasonの確認が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/kubelet/events/event.go` - kubeletイベント定数定義（Container, Pod, Image, Node, Volume, Probe, Lifecycle等）
- E-02: `pkg/controller/volume/events/event.go` - PV/PVC関連イベント定数定義
- E-03: `pkg/kubelet/events/resize.go` - Podリサイズ関連イベントメッセージ生成
- E-04: `pkg/volume/util/operationexecutor/operation_generator.go` - ボリューム操作時のイベント発行箇所
- E-05: `pkg/controller/podautoscaler/horizontal.go` - HPAコントローラのイベント発行箇所
- E-06: `pkg/controller/deployment/sync.go` - Deploymentコントローラのイベント発行箇所
- E-07: `pkg/controller/deployment/rollback.go` - Deploymentロールバック時のイベント発行箇所
- E-08: `pkg/controller/deployment/deployment_controller.go` - Deploymentコントローラのイベント発行箇所
- E-09: `pkg/controller/cronjob/cronjob_controllerv2.go` - CronJobコントローラのイベント発行箇所
- E-10: `pkg/controller/cronjob/utils.go` - CronJobユーティリティのイベント発行箇所
- E-11: `pkg/controller/job/job_controller.go` - Jobコントローラのイベント発行箇所
- E-12: `pkg/controller/tainteviction/taint_eviction.go` - TaintEvictionコントローラのイベント発行箇所
- E-13: `pkg/controller/devicetainteviction/device_taint_eviction.go` - DeviceTaintEvictionコントローラのイベント発行箇所
- E-14: `pkg/controller/util/node/controller_utils.go` - ノードコントローラユーティリティのイベント発行箇所
- E-15: `pkg/controller/endpointslice/endpointslice_controller.go` - EndpointSliceコントローラのイベント発行箇所
- E-16: `pkg/controller/endpoint/endpoints_controller.go` - Endpointsコントローラのイベント発行箇所
- E-17: `pkg/controller/endpointslicemirroring/reconciler.go` - EndpointSliceミラーリングのイベント発行箇所
- E-18: `pkg/controller/disruption/disruption.go` - PDB(PodDisruptionBudget)コントローラのイベント発行箇所
- E-19: `pkg/controller/garbagecollector/graph_builder.go` - GCのイベント発行箇所
- E-20: `pkg/controller/statefulset/stateful_pod_control.go` - StatefulSetのイベント発行箇所
- E-21: `pkg/controller/volume/persistentvolume/pv_controller.go` - PVコントローラのイベント発行箇所
- E-22: `pkg/scheduler/schedule_one.go` - スケジューラのイベント発行箇所
- E-23: `pkg/kubelet/kubelet.go` - kubelet本体のイベント発行箇所
- E-24: `pkg/kubelet/eviction/eviction_manager.go` - エビクションマネージャのイベント発行箇所
- E-25: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` - ノードシャットダウンマネージャのイベント発行箇所
- E-26: `pkg/kubelet/images/image_gc_manager.go` - イメージGCマネージャのイベント発行箇所
- E-27: `pkg/kubelet/network/dns/dns.go` - DNS設定のイベント発行箇所
- E-28: `pkg/kubelet/oom/oom_watcher_linux.go` - OOMウォッチャのイベント発行箇所
- E-29: `pkg/kubelet/podcertificate/podcertificatemanager.go` - Pod証明書マネージャのイベント発行箇所
- E-30: `pkg/kubelet/cm/node_container_manager_linux.go` - ノードコンテナマネージャのイベント発行箇所
- E-31: `pkg/kubelet/kuberuntime/kuberuntime_manager.go` - ランタイムマネージャのイベント発行箇所
- E-32: `pkg/kubelet/prober/prober.go` - プローバのイベント発行箇所
- E-33: `pkg/kubelet/kubelet_pods.go` - kubelet Pods処理のイベント発行箇所
- E-34: `pkg/proxy/healthcheck/service_health.go` - ヘルスチェックのイベント発行箇所
- E-35: `pkg/controller/volume/selinuxwarning/selinux_warning_controller.go` - SELinux警告コントローラのイベント発行箇所
- E-36: `pkg/kubelet/allocation/allocation_manager.go` - アロケーションマネージャのイベント発行箇所
- E-37: `pkg/volume/volume_linux.go` - Linuxボリューム操作のイベント発行箇所
- E-38: `pkg/volume/local/local.go` - ローカルボリュームプラグインのイベント発行箇所
- E-39: `pkg/controller/volume/ephemeral/controller.go` - エフェメラルボリュームコントローラのイベント発行箇所

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | No.1 Created - コンテナ作成通知 | E-01 | ○ |
| C-02 | No.2 Started - コンテナ起動通知 | E-01 | ○ |
| C-03 | No.3 Failed (CreateContainer) - コンテナ作成失敗通知 | E-01 | ○ |
| C-04 | No.4 Failed (StartContainer) - コンテナ起動失敗通知 | E-01 | ○ |
| C-05 | No.5 Killing - コンテナ強制終了通知 | E-01 | ○ |
| C-06 | No.6 Preempting - コンテナプリエンプション通知 | E-01 | ○ |
| C-07 | No.7 BackOff - コンテナ起動バックオフ通知 | E-01, E-31 | ○ |
| C-08 | No.8 ExceededGracePeriod - 猶予期間超過通知 | E-01, E-23 | ○ |
| C-09 | No.9 FailedKillPod - Pod強制終了失敗通知 | E-01, E-23 | ○ |
| C-10 | No.10 FailedCreatePodContainer - Podコンテナ作成失敗通知 | E-01, E-23 | ○ |
| C-11 | No.11 Failed (MakePodDataDirectories) - Podディレクトリ作成失敗通知 | E-01, E-23 | ○ |
| C-12 | No.12 NetworkNotReady - ネットワーク未準備通知 | E-01, E-23 | ○ |
| C-13 | No.13-17 Resize関連通知 | E-01, E-03, E-36 | ○ |
| C-14 | No.18 FailedNodeDeclaredFeaturesCheck | E-01, E-23 | ○ |
| C-15 | No.19-24 イメージ関連通知 | E-01 | ○ |
| C-16 | No.25-38 ノード関連通知 | E-01, E-23, E-25, E-26, E-30 | ○ |
| C-17 | No.39-51 ボリューム関連通知 | E-01, E-04, E-37, E-38 | ○ |
| C-18 | No.52-63 PVC/PV関連通知 | E-02, E-21 | ○ |
| C-19 | No.61 WaitForFirstConsumer - 定数は確認済み | E-02 | △ |
| C-20 | No.62 WaitForPodScheduled - 定数は確認済み | E-02 | △ |
| C-21 | No.63 ExternalExpanding - 定数は確認済み | E-02 | △ |
| C-22 | No.64-66 サンドボックス関連通知 | E-01, E-31 | ○ |
| C-23 | No.67-68 プローブ関連通知 | E-01, E-32 | ○ |
| C-24 | No.69-70 ライフサイクルフック通知 | E-01 | ○ |
| C-25 | No.71-72 イメージマネージャ通知 | E-01, E-26 | ○ |
| C-26 | No.73 FailedSync - 同期失敗通知 | E-01, E-23 | ○ |
| C-27 | No.74 FailedValidation - バリデーション失敗通知 | E-01 | ○ |
| C-28 | No.75-76 スケジューラ通知 | E-22 | ○ |
| C-29 | No.77-84 HPA関連通知 | E-05 | ○ |
| C-30 | No.85-88 Deployment関連通知 | E-06, E-07, E-08 | ○ |
| C-31 | No.89 StatefulSet ConflictingController通知 | E-20 | ○ |
| C-32 | No.90-103 CronJob関連通知 | E-09, E-10 | ○ |
| C-33 | No.104-108 Job関連通知 | E-11 | ○ |
| C-34 | No.109 EvictionThresholdMet通知 | E-24 | ○ |
| C-35 | No.110 TaintManagerEviction通知 | E-12 | ○ |
| C-36 | No.111 DeviceTaintManagerEviction通知 | E-13 | ○ |
| C-37 | No.112-113 ノードコントローラ通知 | E-14 | ○ |
| C-38 | No.114-116 EndpointSlice通知 | E-15 | ○ |
| C-39 | No.117-118 Endpoint通知 | E-16 | ○ |
| C-40 | No.119-120 EndpointSliceミラーリング通知 | E-17 | ○ |
| C-41 | No.121-125 PDB関連通知 | E-18 | ○ |
| C-42 | No.126 GC OwnerRefInvalidNamespace通知 | E-19 | ○ |
| C-43 | No.127-129 DNS関連通知 | E-27 | ○ |
| C-44 | No.130 SystemOOM通知 | E-28 | ○ |
| C-45 | No.131 SELinux MultipleSELinuxLabels通知 | E-35 | ○ |
| C-46 | No.132-133 証明書関連通知 | E-29 | ○ |
| C-47 | No.134 HealthCheckNodePort通知 | E-34 | △ |
| C-48 | No.135 FailedToRetrieveImagePullSecret通知 | E-33 | ○ |

## 4) 不足情報（Unknown / Missing）
- No.61, 62, 63（WaitForFirstConsumer, WaitForPodScheduled, ExternalExpanding）：定数定義は `pkg/controller/volume/events/event.go` で確認したが、これらの定数を使用してEventを発行する箇所の直接的な確認が網羅的に行えていない。外部プロビジョナーや他のコンポーネントから発行される可能性がある。
  - 候補：`staging/src/k8s.io/` 配下のコード / 外部プロビジョナーの実装 / CSIドライバ
- No.134（HealthCheckNodePort）：`pkg/proxy/healthcheck/service_health.go` でEventRecorderの利用は確認したが、具体的なEvent Reasonの詳細確認が不足。
  - 候補：`pkg/proxy/` 配下の詳細コード / kube-proxyの実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の通知イベントはソースコード上の定数定義と発行箇所の両方で確認済み
- 1: 中リスク - PVC関連の一部イベント（WaitForFirstConsumer等）は外部コンポーネントから発行される可能性があり、本リポジトリだけでは完全に検証できない
- 0: 低リスク - Kubernetesは内部通知にEvent APIを使用しており、外部メール/Slack等の通知機構は含まれない（正しくEvent APIのみを対象としている）

## 6) レビュアーチェックリスト（最小）
- [ ] 通知一覧のカテゴリ分類が適切か確認する
- [ ] EventType（Normal/Warning）の分類が各イベントの性質と合致しているか確認する
- [ ] staging/src/k8s.io/ 配下に追加の通知イベントが存在しないか確認する
- [ ] 外部CSIドライバやAdmission Webhookから発行されるイベントが対象外であることを確認する
- [ ] No.61-63のPVC関連イベントの発行元が正しいか、コード上で発行箇所を追跡して確認する
- [ ] No.134のHealthCheck関連イベントの具体的なReasonを確認する
