# 通知設計書 10-FailedCreatePodContainer

## 概要

本ドキュメントは、Kubernetesのkubeletがpodコンテナの作成に失敗した際に発行する「FailedCreatePodContainer」イベント通知の設計を記述する。

### 本通知の処理概要

kubeletがPodの同期処理（syncPod）において、Podのcgroup（コントロールグループ）の確保に失敗した場合に、Kubernetes Event APIを用いて「FailedCreatePodContainer」イベントを記録する通知である。Podレベルのリソース管理基盤であるcgroupの作成・適用失敗を報告する。

**業務上の目的・背景**：Podのcgroupは、コンテナのリソース制限（CPU、メモリ等）を管理するLinuxカーネルの機能である。cgroupの作成に失敗すると、Pod内のすべてのコンテナの起動が不可能になる。この通知により、運用者はノードのcgroup設定やリソース管理に問題があることを検知でき、ノードの健全性確認やcgroup設定の見直しを行える。

**通知の送信タイミング**：`syncPod`関数内で、PodContainerManager.EnsureExistsがエラーを返した場合に発行される（`kubelet.go` 2107行目）。具体的には、Podのcgroupが存在しない場合に作成を試み、その作成または適用に失敗した場合である。

**通知の受信者**：Kubernetes Event APIを通じて記録されるため、kubectl eventsやモニタリングツールを利用するクラスタ管理者が受信者となる。Warning Eventであるため監視アラート対象となる。

**通知内容の概要**：イベントにはEventType（Warning）、Reason（FailedCreatePodContainer）、およびメッセージ"unable to ensure pod container exists: {エラー内容}"が含まれる。

**期待されるアクション**：運用者はノードのcgroup設定を確認する。具体的には、cgroupドライバ（systemd/cgroupfs）の設定、cgroup v1/v2の互換性、ノードのリソース状態を確認する。QoSクラスのcgroup構造に問題がある場合は、ノードの再起動やkubeletの再設定が必要になる場合がある。

## 通知種別

Kubernetes Eventオブジェクト（API内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Event APIへの書き込み） |
| 優先度 | 高（Warning Event） |
| リトライ | Event API書き込み失敗時はkubelet内部でリトライ |

### 送信先決定ロジック

対象のPodオブジェクトに対してrecorder.Eventfを呼び出し、Kubernetes Event APIサーバへ送信する。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Event APIオブジェクトとして発行されるため、メール通知は該当しない。

### 本文テンプレート

```
unable to ensure pod container exists: {エラー内容}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Pod名 | 対象Podの名前 | Pod.ObjectMeta.Name | Yes |
| Namespace | 対象PodのNamespace | Pod.ObjectMeta.Namespace | Yes |
| エラー内容 | EnsureExistsのエラーメッセージ | pcm.EnsureExists()の戻り値err | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet内部 | Pod cgroup作成失敗 | PodContainerManager.EnsureExistsがエラーを返す | cgroupの作成または適用に失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| cgroup既存 | Podのcgroupが既に存在する場合はEnsureExistsが呼ばれない |
| Pod停止済み | Podが既に停止処理中の場合はcgroup作成をスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncPod] --> B{Pod停止済み?}
    B -->|はい| C[スキップ]
    B -->|いいえ| D{cgroup存在?}
    D -->|はい| E[次の処理へ]
    D -->|いいえ| F[UpdateQOSCgroups]
    F --> G[pcm.EnsureExists]
    G --> H{作成成功?}
    H -->|成功| I[次の処理へ]
    H -->|失敗| J[recorder.Eventf: FailedCreatePodContainer]
    J --> K[エラー返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd（Podオブジェクト） | Podメタデータ参照 | kube-apiserver経由 |
| ノードローカル | cgroup情報 | /sys/fs/cgroup配下 |

### テーブル別参照項目詳細

#### Podオブジェクト

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ObjectMeta.UID | Pod固有のcgroupパス生成 | syncPod処理時 |
| Spec.Containers[].Resources | リソース制限の適用 | cgroup作成時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd（Eventオブジェクト） | INSERT | FailedCreatePodContainerイベントオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "FailedCreatePodContainer" | イベント理由 |
| INSERT | Event.Type | "Warning" | 警告イベント |
| INSERT | Event.Message | "unable to ensure pod container exists: {err}" | エラーメッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| cgroup作成失敗 | cgroupの作成権限不足やパス問題 | ノードのcgroup設定確認、kubelet再起動 |
| cgroup適用失敗 | リソース制限値の不正 | Pod Specのリソース設定確認 |
| cgroupドライバ不一致 | systemd/cgroupfsの不一致 | kubeletとコンテナランタイムのcgroupドライバ設定を統一 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 次回のsyncPodループで自動リトライ |
| リトライ間隔 | Pod同期間隔に依存 |
| リトライ対象エラー | すべてのEnsureExistsエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのバースト制限に依存 |
| 1日あたり上限 | 明示的な上限なし（同一イベントは集約） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- エラーメッセージにはcgroupパスなどのノード内部情報が含まれる可能性がある。
- cgroupの設定はノードのセキュリティ設定に関わるため、適切なアクセス制御が必要。

## 備考

- 本イベントはkubelet.goの`syncPod`関数（2107行目）で発行される。
- イベント定数は`pkg/kubelet/events/event.go` 34行目で`FailedToCreatePodContainer = "FailedCreatePodContainer"`として定義されている。
- EnsureExists呼び出し前に`containerManager.UpdateQOSCgroups`が呼ばれ、QoSクラス用のcgroupが更新される（2102行目）。
- cgroup作成失敗後、syncPodはfalseとエラーを返却し、Podの処理が中断される（2108行目）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 34行目: `FailedToCreatePodContainer = "FailedCreatePodContainer"` の定数定義 |

**読解のコツ**: FailedToCreatePodContainerはPod event reason listに含まれ、個々のコンテナではなくPod全体のcgroup作成に関するイベントである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 2099-2114行目: syncPod内のcgroup作成処理 |

**主要処理フロー**:
1. **2099行目**: podKilledまたはrunOnceの条件チェック
2. **2100行目**: pcm.Exists(pod)でcgroupの存在確認
3. **2102行目**: containerManager.UpdateQOSCgroupsでQoSクラスcgroup更新
4. **2106行目**: pcm.EnsureExists(pod)でPod用cgroup作成
5. **2107行目**: 失敗時にrecorder.EventfでFailedCreatePodContainerイベント発行
6. **2108行目**: false + エラーを返却

#### Step 3: PodContainerManagerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pod_container_manager_linux.go | `pkg/kubelet/cm/pod_container_manager_linux.go` | EnsureExists関数の実装 |

**主要処理フロー**:
- cgroupパスの生成
- cgroupの作成
- リソース制限の適用

### プログラム呼び出し階層図

```
podWorkers.managePodLoop()
    |
    +-- kubelet.SyncPod()
           |
           +-- syncPod()                                [kubelet.go:2099]
                  |
                  +-- pcm.Exists(pod)                    [cgroup存在確認]
                  +-- containerManager.UpdateQOSCgroups() [行2102]
                  +-- pcm.EnsureExists(pod)              [行2106]
                         |
                         +-- [失敗] recorder.Eventf(FailedCreatePodContainer)  [行2107]
                         +-- return false, error
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Pod Spec          ------>  syncPod()                        ------>  Kubernetes Event
(リソース要求)               |                                        (Type: Warning,
                             +-- pcm.Exists()                        Reason: FailedCreatePodContainer,
                             +-- UpdateQOSCgroups()                  Message: "unable to ensure pod
                             +-- pcm.EnsureExists()                   container exists: {err}")
                             |
cgroup Error      <------  PodContainerManager
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncPod内のcgroup作成・FailedCreatePodContainerイベント発行 |
| pod_container_manager_linux.go | `pkg/kubelet/cm/pod_container_manager_linux.go` | ソース | PodContainerManagerの実装（EnsureExists等） |
| container_manager_linux.go | `pkg/kubelet/cm/container_manager_linux.go` | ソース | ContainerManager（UpdateQOSCgroups等） |
