# 通知設計書 101-TooManyMissedTimes

## 概要

本ドキュメントは、KubernetesのCronJobコントローラーが発行する「TooManyMissedTimes」イベント通知の設計を記述する。CronJobのスケジュール実行が100回以上ミスされた場合に警告として発行される。

### 本通知の処理概要

CronJobコントローラーがスケジュール時刻の計算処理中に、未実行のスケジュール回数が100回を超えた場合に発行される警告イベントである。

**業務上の目的・背景**：CronJobのスケジュール実行が大量にミスされている状態は、コントローラーの障害、クロックスキュー、または不正な設定を示唆する。この通知により、運用者がCronJobの設定やシステム状態を確認し、問題を早期に是正できるようにする。大量のミススケジュールはコントローラーのCPU・メモリを消費する可能性があるため、早期検出が重要である。

**通知の送信タイミング**：CronJobコントローラーのsyncCronJobループ内で次回スケジュール時刻を計算する際、`mostRecentScheduleTime`関数が未実行スケジュール数を算出し、その数が100を超えた場合に`nextScheduleTime`関数内でイベントが発行される。

**通知の受信者**：Kubernetes Event APIを通じてCronJobオブジェクトに関連付けられるため、`kubectl get events`やEventを監視するモニタリングツール（Prometheus、Datadog等）を通じてクラスタ管理者やSRE担当者が受信する。

**通知内容の概要**：「too many missed start times. Set or decrease .spec.startingDeadlineSeconds or check clock skew」というメッセージが含まれ、CronJobのスケジュールミスが多すぎることと、推奨される対処方法を通知する。

**期待されるアクション**：受信者は`.spec.startingDeadlineSeconds`の設定・減少、コントローラーやApiserverのクロックスキューの確認、CronJobのスケジュール設定の見直しを行う。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sync処理内で即座に発行） |
| 優先度 | 高（Warning） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

CronJobオブジェクト自体がイベントの対象（InvolvedObject）となる。イベントはKubernetes APIサーバーに記録され、Namespace内のイベントとして参照可能となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | TooManyMissedTimes |
| 発行元コンポーネント | cronjob-controller |

### 本文テンプレート

```
too many missed start times. Set or decrease .spec.startingDeadlineSeconds or check clock skew
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本イベントは固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラー同期 | CronJobのsyncCronJob実行 | 未実行スケジュール数 > 100 | `mostRecentScheduleTime`関数で`numberOfMissedSchedules`が100を超えた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| スケジュールミスが100以下 | 未実行スケジュール数が100以下の場合は発行されない |
| CronJobが一時停止中 | `spec.suspend`がtrueの場合、syncCronJob処理自体がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CronJob sync開始] --> B[スケジュール解析]
    B --> C[nextScheduleTime呼び出し]
    C --> D[mostRecentScheduleTime計算]
    D --> E{missedSchedules判定}
    E -->|manyMissed > 100| F[TooManyMissedTimes Event発行]
    E -->|fewMissed or noneMissed| G[通常処理継続]
    F --> H[ログ出力]
    H --> I[mostRecentTime返却]
    G --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJobオブジェクト | スケジュール設定、LastScheduleTime取得 | etcd経由 |

### テーブル別参照項目詳細

#### CronJobオブジェクト

| 参照項目（フィールド名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.schedule | スケジュール式の解析 | syncCronJob時 |
| spec.startingDeadlineSeconds | スケジュール計算の基準時間調整 | 設定されている場合 |
| status.lastScheduleTime | 最終実行時刻の取得 | sync時に参照 |
| metadata.creationTimestamp | 初回基準時間の決定 | lastScheduleTimeがない場合 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Eventオブジェクト | INSERT | 警告イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スケジュール解析エラー | 不正なcron式（例：31日2月） | エラーをログに記録し、nilを返却 |
| Event発行失敗 | APIサーバー接続エラー | EventBroadcasterの内部リトライに依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし（ただしEvent集約が適用される） |

### 配信時間帯

制限なし。CronJobのsync処理が実行されるたびに条件判定される。

## セキュリティ考慮事項

本イベントにはCronJobの名前とNamespaceのみが含まれ、機密情報は含まれない。Kubernetes RBACにより、Eventの閲覧権限はNamespaceレベルで制御される。

## 備考

- 100回の閾値はKubernetesソースコード内でハードコードされている（`pkg/controller/cronjob/utils.go`の170行目）
- コントローラーが長時間停止した場合（例：金曜夕方から火曜朝まで）、毎時のCronJobで80回以上のミスが発生しうるが、この閾値はそれよりも大きく設定されている
- `startingDeadlineSeconds`を設定することで、計算対象期間を制限し、本警告の発生を防ぐことができる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CronJobオブジェクトのスケジュール関連フィールドと、missedSchedulesType列挙型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | utils.go | `pkg/controller/cronjob/utils.go` | missedSchedulesType型の定義（38-43行目）とnoneMissed/fewMissed/manyMissedの区分 |

**読解のコツ**: Go言語のiota定数で定義されており、0=noneMissed, 1=fewMissed, 2=manyMissedとなる。

#### Step 2: エントリーポイントを理解する

CronJobコントローラーのsync処理がどのようにスケジュール計算に到達するかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | syncCronJob関数（426-674行目）からnextScheduleTimeの呼び出し（528行目） |

**主要処理フロー**:
1. **188行目**: sync関数がcronJobKeyで同期処理を開始
2. **216行目**: syncCronJobを呼び出し
3. **519行目**: formatScheduleでスケジュール文字列を生成
4. **528行目**: nextScheduleTimeを呼び出し、ここでTooManyMissedTimesが発行される可能性がある

#### Step 3: スケジュール計算とイベント発行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | utils.go | `pkg/controller/cronjob/utils.go` | mostRecentScheduleTime関数（100-181行目）でのミススケジュール数計算 |
| 3-2 | utils.go | `pkg/controller/cronjob/utils.go` | nextScheduleTime関数（210-223行目）でのイベント発行ロジック |

**主要処理フロー**:
- **136行目**: numberOfMissedSchedulesの計算（経過時間 / スケジュール間隔 + 1）
- **170行目**: numberOfMissedSchedules > 100 の場合、manyMissedに設定
- **217-220行目**: missedSchedules == manyMissed の場合、recorder.Eventfで"TooManyMissedTimes"イベントを発行

### プログラム呼び出し階層図

```
ControllerV2.processNextWorkItem
    |
    +-- ControllerV2.sync
            |
            +-- ControllerV2.syncCronJob
                    |
                    +-- nextScheduleTime (utils.go:210)
                            |
                            +-- mostRecentScheduleTime (utils.go:100)
                            |       |
                            |       +-- numberOfMissedSchedules計算 (136行目)
                            |       +-- missedSchedules判定 (169-175行目)
                            |
                            +-- recorder.Eventf "TooManyMissedTimes" (218行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

CronJob.spec.schedule     --> cron.ParseStandard           --> schedule
CronJob.status            --> mostRecentScheduleTime       --> missedSchedulesType
  .lastScheduleTime
  .creationTimestamp
                          --> nextScheduleTime
                              missedSchedules == manyMissed --> Event "TooManyMissedTimes"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | CronJobコントローラーのメインロジック |
| utils.go | `pkg/controller/cronjob/utils.go` | ソース | スケジュール計算ユーティリティ、イベント発行 |
