# 通知設計書 102-JobAlreadyActive

## 概要

本ドキュメントは、KubernetesのCronJobコントローラーが発行する「JobAlreadyActive」イベント通知の設計を記述する。ConcurrencyPolicyがForbidに設定されたCronJobにおいて、前回のJobがまだ実行中のために新規Job作成がスキップされた場合に発行される。

### 本通知の処理概要

CronJobコントローラーがスケジュールに基づいて新規Jobを作成しようとした際に、ConcurrencyPolicyがForbidであり、かつアクティブなJobが存在する場合に発行されるNormalイベントである。

**業務上の目的・背景**：ConcurrencyPolicy=ForbidはCronJobの並行実行を防止するためのポリシーである。この通知は、スケジュール時刻にJobの新規作成がスキップされたことを運用者に通知し、前回のJobが期待通りに完了していない状況の把握を可能にする。これにより、ジョブの実行時間が長すぎるか、設定の見直しが必要かを判断する材料を提供する。

**通知の送信タイミング**：CronJobのsyncCronJob処理内で、スケジュール時刻に達した後、ConcurrencyPolicyの判定時にアクティブなJobが存在する場合に発行される。具体的には`cronjob_controllerv2.go`の573-586行目で判定・発行される。

**通知の受信者**：Kubernetes Event APIを通じてCronJobオブジェクトに関連付けられるため、`kubectl get events`やモニタリングツールを通じてクラスタ管理者が受信する。

**通知内容の概要**：「Not starting job because prior execution is running and concurrency policy is Forbid」というメッセージが含まれ、前回のJobが実行中であるために新規Jobの作成がスキップされたことを通知する。

**期待されるアクション**：受信者はアクティブなJobの実行状況を確認し、Jobの実行時間が長すぎる場合はタイムアウト設定（activeDeadlineSeconds）の追加や、ConcurrencyPolicyの変更を検討する。

## 通知種別

Kubernetes Event（Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sync処理内で即座に発行） |
| 優先度 | 中（Normal） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

CronJobオブジェクト自体がイベントの対象（InvolvedObject）となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Normal |
| Reason | JobAlreadyActive |
| 発行元コンポーネント | cronjob-controller |

### 本文テンプレート

```
Not starting job because prior execution is running and concurrency policy is Forbid
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本イベントは固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラー同期 | CronJobのsyncCronJob実行 | ConcurrencyPolicy=Forbid かつ Active Jobが1件以上存在 | スケジュール時刻到達後の判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ConcurrencyPolicyがForbid以外 | AllowまたはReplaceの場合は本イベントは発行されない |
| アクティブJobなし | cronJob.Status.Activeが空の場合 |
| CronJobが一時停止中 | spec.suspendがtrueの場合 |
| スケジュール時刻未到達 | scheduledTimeがnilの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncCronJob開始] --> B[スケジュール時刻計算]
    B --> C{scheduledTime != nil?}
    C -->|No| D[次回スケジュール待ち]
    C -->|Yes| E{ConcurrencyPolicy判定}
    E -->|Forbid| F{Active Jobs > 0?}
    E -->|Allow/Replace| G[Job作成処理]
    F -->|Yes| H[JobAlreadyActive Event発行]
    F -->|No| G
    H --> I[次回スケジュール計算]
    I --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJobオブジェクト | ConcurrencyPolicy、ActiveリストのJob確認 | etcd経由 |

### テーブル別参照項目詳細

#### CronJobオブジェクト

| 参照項目（フィールド名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.concurrencyPolicy | ポリシー判定 | syncCronJob時 |
| status.active | アクティブJob数確認 | len > 0 で判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Eventオブジェクト | INSERT | 通知イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Event発行失敗 | APIサーバー接続エラー | EventBroadcasterの内部リトライに依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし（Event集約が適用される） |

### 配信時間帯

制限なし。CronJobのスケジュール時刻ごとに条件判定される。

## セキュリティ考慮事項

本イベントにはCronJobの名前とNamespaceのみが含まれ、機密情報は含まれない。

## 備考

- ConcurrencyPolicy=Forbidの場合、理論的にはJobが完了するまで新しいJobは作成されないが、情報の遅延により並行実行が発生する可能性がある（ソースコードのコメント参照、573-581行目）
- ConcurrencyPolicy=Replaceの場合は、既存のJobが削除されてから新規Jobが作成される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CronJobのConcurrencyPolicy設定とActiveリストの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `vendor/k8s.io/api/batch/v1/types.go` | ConcurrencyPolicy型（ForbidConcurrent定数）とCronJobStatus.Activeフィールド |

**読解のコツ**: batchv1.ForbidConcurrentは文字列定数"Forbid"として定義されている。

#### Step 2: エントリーポイントを理解する

syncCronJob関数内のConcurrencyPolicy判定ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | syncCronJob関数の573-586行目でForbid判定とイベント発行 |

**主要処理フロー**:
1. **573行目**: `cronJob.Spec.ConcurrencyPolicy == batchv1.ForbidConcurrent`の判定
2. **573行目**: `len(cronJob.Status.Active) > 0`の判定
3. **584行目**: `recorder.Eventf`で"JobAlreadyActive"イベントを発行
4. **585行目**: 次回スケジュール時間を計算して返却

### プログラム呼び出し階層図

```
ControllerV2.processNextWorkItem
    |
    +-- ControllerV2.sync
            |
            +-- ControllerV2.syncCronJob (426行目)
                    |
                    +-- ConcurrencyPolicy判定 (573行目)
                    |       |
                    |       +-- ForbidConcurrent && Active > 0
                    |               |
                    |               +-- recorder.Eventf "JobAlreadyActive" (584行目)
                    |
                    +-- nextScheduleTimeDuration (585行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

CronJob.spec                --> syncCronJob
  .concurrencyPolicy            ConcurrencyPolicy判定
CronJob.status.active       --> len(active) > 0              --> Event "JobAlreadyActive"
                                                             --> nextScheduleTimeDuration
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | CronJobコントローラーのメインロジック、イベント発行 |
| utils.go | `pkg/controller/cronjob/utils.go` | ソース | スケジュール計算ユーティリティ |
