# 通知設計書 103-UnsupportedSchedule

## 概要

本ドキュメントは、KubernetesのCronJobコントローラーが発行する「UnsupportedSchedule」イベント通知の設計を記述する。CronJobのスケジュール式にCRON_TZまたはTZプレフィックスが使用されている場合に警告として発行される。

### 本通知の処理概要

CronJobのスケジュール文字列に「TZ」が含まれている場合に発行される警告イベントである。CRON_TZやTZは非公式にサポートされた機能であり、公式のspec.timeZoneフィールドの使用が推奨される。

**業務上の目的・背景**：Kubernetes 1.27以降、CronJobにはspec.timeZoneフィールドが正式にサポートされている。CRON_TZ/TZを使用したスケジュール式は非公式な方法であり、将来のバージョンで動作が変更される可能性がある。この通知により、運用者に公式のタイムゾーン設定方法への移行を促す。

**通知の送信タイミング**：CronJobのsyncCronJob処理内で`formatSchedule`関数が呼ばれた際、スケジュール文字列に"TZ"が含まれていることが検出された場合に発行される。具体的には`cronjob_controllerv2.go`の766-773行目で発行される。

**通知の受信者**：Kubernetes Event APIを通じてCronJobオブジェクトに関連付けられるため、`kubectl get events`やモニタリングツールを通じてクラスタ管理者が受信する。

**通知内容の概要**：CRON_TZまたはTZがスケジュール式で使用されていることと、公式サポートではないことを通知し、Kubernetesドキュメントへのリンクを含む。

**期待されるアクション**：受信者はspec.timeZoneフィールドを使用する方式に移行し、スケジュール式からCRON_TZ/TZプレフィックスを削除する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sync処理内で即座に発行） |
| 優先度 | 中（Warning） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

CronJobオブジェクト自体がイベントの対象（InvolvedObject）となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | UnsupportedSchedule |
| 発行元コンポーネント | cronjob-controller |

### 本文テンプレート

```
CRON_TZ or TZ used in schedule %q is not officially supported, see https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/ for more details
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| %q | CronJobのスケジュール式 | cronJob.Spec.Schedule | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラー同期 | CronJobのsyncCronJob実行 | spec.scheduleに"TZ"文字列が含まれる | formatSchedule関数内でstrings.Containsにより判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| スケジュール式にTZが含まれない | 通常のcron式の場合は発行されない |
| recorderがnil | formatSchedule関数のrecorder引数がnilの場合（updateCronJobからの呼び出し時） |
| CronJobが一時停止中 | spec.suspendがtrueの場合、syncCronJob処理がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncCronJob開始] --> B[formatSchedule呼び出し]
    B --> C{schedule に "TZ" を含む?}
    C -->|Yes| D{recorder != nil?}
    C -->|No| E[通常のスケジュール返却]
    D -->|Yes| F[UnsupportedSchedule Event発行]
    D -->|No| G[イベントなしでスケジュール返却]
    F --> H[スケジュール文字列返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJobオブジェクト | スケジュール式の参照 | etcd経由 |

### テーブル別参照項目詳細

#### CronJobオブジェクト

| 参照項目（フィールド名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.schedule | TZ含有チェック | syncCronJob時 |
| spec.timeZone | タイムゾーン指定の確認 | formatSchedule内 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Eventオブジェクト | INSERT | 警告イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Event発行失敗 | APIサーバー接続エラー | EventBroadcasterの内部リトライに依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし（Event集約が適用される） |

### 配信時間帯

制限なし。CronJobのsync処理が実行されるたびに条件判定される。

## セキュリティ考慮事項

本イベントにはCronJobのスケジュール式が含まれるが、機密情報は含まれない。

## 備考

- formatSchedule関数はsyncCronJobからの呼び出し時にrecorderが渡されるが、updateCronJobからの呼び出し時にはnilが渡されるため、更新時の呼び出しではイベントが発行されない
- CRON_TZ/TZ式はcron/v3ライブラリによって解析されるため、機能自体は動作する
- 推奨される方法はspec.timeZoneフィールドの使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CronJobのスケジュール関連フィールドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `vendor/k8s.io/api/batch/v1/types.go` | CronJobSpec.Schedule、CronJobSpec.TimeZoneフィールド |

#### Step 2: エントリーポイントを理解する

formatSchedule関数の呼び出し元を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | syncCronJob内のformatSchedule呼び出し（519行目） |

**主要処理フロー**:
1. **519行目**: `formatSchedule(cronJob, jm.recorder)`でrecorder付きで呼び出し
2. **766行目**: formatSchedule関数の定義
3. **767行目**: `strings.Contains(cj.Spec.Schedule, "TZ")`で判定
4. **769行目**: `recorder.Eventf`で"UnsupportedSchedule"イベント発行

#### Step 3: formatSchedule関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | formatSchedule関数（766-784行目）の3つの分岐を理解する |

**主要処理フロー**:
- **767行目**: TZ含有チェック → イベント発行してスケジュール式をそのまま返却
- **775行目**: spec.TimeZone設定時 → "TZ={timezone} {schedule}"形式で返却
- **783行目**: それ以外 → スケジュール式をそのまま返却

### プログラム呼び出し階層図

```
ControllerV2.syncCronJob (426行目)
    |
    +-- formatSchedule (519行目, 766行目)
            |
            +-- strings.Contains(schedule, "TZ") (767行目)
            |       |
            |       +-- recorder.Eventf "UnsupportedSchedule" (769行目)
            |
            +-- parsers.ParseCronScheduleWithPanicRecovery
```

### データフロー図

```
[入力]                          [処理]                              [出力]

CronJob.spec.schedule     --> formatSchedule
  (例: "CRON_TZ=JST ...")      strings.Contains("TZ")       --> Event "UnsupportedSchedule"
                                                             --> スケジュール文字列（そのまま）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | CronJobコントローラー、formatSchedule関数 |
| utils.go | `pkg/controller/cronjob/utils.go` | ソース | スケジュール計算ユーティリティ |
