# 通知設計書 105-Suspended

## 概要

本ドキュメントは、KubernetesのJobコントローラーが発行する「Suspended」イベント通知の設計を記述する。Jobが一時停止された際にNormalイベントとして発行される。

### 本通知の処理概要

Jobコントローラーの同期処理内で、Jobのspec.suspendフィールドがtrueに設定され、status.conditionsにJobSuspended条件が新たに追加された場合に発行されるNormalイベントである。

**業務上の目的・背景**：Jobの一時停止機能により、ユーザーはJobの実行を一時的に停止できる。この通知により、運用者がJobの一時停止状態の変更を検知し、意図した操作であることの確認や、後続作業の計画が可能となる。MutableSchedulingDirectivesForSuspendedJobs機能が有効な場合、一時停止中にスケジューリング指示の変更が可能となる。

**通知の送信タイミング**：Jobコントローラーのsync処理内で`manageJob`が呼び出された後、Jobがsuspend状態であり、かつJobSuspended条件がConditionTrueに新たに設定された場合に発行される。具体的には`job_controller.go`の1049行目で発行される。

**通知の受信者**：Kubernetes Event APIを通じてJobオブジェクトに関連付けられるため、`kubectl get events`やモニタリングツールを通じてクラスタ管理者が受信する。

**通知内容の概要**：「Job suspended」というメッセージが含まれ、Jobが一時停止状態になったことを通知する。

**期待されるアクション**：意図した操作であることを確認する。必要に応じて、一時停止中にスケジューリング指示の変更やリソース調整を行い、準備ができたらsuspendをfalseに設定してJobを再開する。

## 通知種別

Kubernetes Event（Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sync処理内で即座に発行） |
| 優先度 | 低（Normal） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

Jobオブジェクト自体がイベントの対象（InvolvedObject）となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Normal |
| Reason | Suspended |
| 発行元コンポーネント | job-controller |

### 本文テンプレート

```
Job suspended
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本イベントは固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラー同期 | Jobのsync処理 | jobSuspended == true かつ JobSuspended条件がConditionTrueに新たに設定 | ensureJobConditionStatusの戻り値isUpdated == true |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にSuspended状態 | JobSuspended条件が既にConditionTrueの場合、isUpdated=falseとなりイベントは発行されない |
| Jobが完了済み | complete=trueの場合、Suspend条件の更新処理は実行されない |
| manageJobが呼び出されていない | manageJobCalledがfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Job sync開始] --> B[manageJob呼び出し]
    B --> C{complete?}
    C -->|Yes| D[完了処理]
    C -->|No| E{manageJobCalled?}
    E -->|No| F[終了]
    E -->|Yes| G{jobSuspended?}
    G -->|Yes| H[ensureJobConditionStatus JobSuspended=True]
    G -->|No| I[ensureJobConditionStatus JobSuspended=False]
    H --> J{isUpdated?}
    J -->|Yes| K[Suspended Event発行]
    J -->|No| L[イベントなし]
    K --> M[StartTime=nil設定（機能有効時）]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Jobオブジェクト | suspend状態の確認 | etcd経由 |

### テーブル別参照項目詳細

#### Jobオブジェクト

| 参照項目（フィールド名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.suspend | 一時停止状態の判定 | sync時 |
| status.conditions | 既存JobSuspended条件の確認 | sync時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Jobオブジェクト | UPDATE | status.conditionsにJobSuspended=True追加、startTime=nil |
| Eventオブジェクト | INSERT | Suspendedイベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ステータス更新失敗 | APIサーバー接続エラー | requeueして再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

本イベントにはJobの名前とNamespaceのみが含まれ、機密情報は含まれない。

## 備考

- MutableSchedulingDirectivesForSuspendedJobs機能フラグが有効な場合、一時停止時にstartTimeがnilに設定される（1050-1052行目）
- Jobが一時停止中はアクティブなPodは存在しない（manageJob内で削除される）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JobのSuspend関連フィールドとConditionを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `vendor/k8s.io/api/batch/v1/types.go` | JobSpec.Suspend、JobConditionType(JobSuspended) |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job_controller.go | `pkg/controller/job/job_controller.go` | syncJob内のsuspend判定（1043-1053行目） |

**主要処理フロー**:
1. **1043行目**: `jobSuspended(&job)`でsuspend状態判定
2. **1046行目**: `ensureJobConditionStatus`でJobSuspended条件をTrue設定
3. **1047行目**: isUpdatedがtrueの場合
4. **1049行目**: `recorder.Event`で"Suspended"イベント発行

### プログラム呼び出し階層図

```
Controller.syncJob
    |
    +-- manageJob
    |
    +-- jobSuspended判定 (1043行目)
            |
            +-- ensureJobConditionStatus (1046行目)
                    |
                    +-- recorder.Event "Suspended" (1049行目)
                    +-- StartTime = nil (1051行目, 機能フラグ有効時)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Job.spec.suspend=true     --> syncJob
                              jobSuspended判定
Job.status.conditions     --> ensureJobConditionStatus
                              isUpdated=true               --> Event "Suspended"
                                                           --> Job.status.conditions更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job_controller.go | `pkg/controller/job/job_controller.go` | ソース | Jobコントローラーのメインロジック |
