# 通知設計書 107-TooManySucceededPods

## 概要

本ドキュメントは、KubernetesのJobコントローラーが発行する「TooManySucceededPods」イベント通知の設計を記述する。Jobの完了数（completions）に到達した後に、成功したPod数がcompletionsを超えている場合に警告として発行される。

### 本通知の処理概要

Jobコントローラーがジョブの完了を記録する`recordJobFinished`関数内で、succeededがspec.completionsを超過している場合に発行されるWarningイベントである。

**業務上の目的・背景**：Jobの完了数に対して成功Pod数が多すぎるということは、Podの管理において予期しない状況が発生したことを示す。これはレースコンディションや、コントローラーの不整合により発生しうる。この通知により、運用者が予期しない余剰Pod実行を検知し、リソース消費やデータの整合性について確認できるようにする。

**通知の送信タイミング**：Jobコントローラーの`recordJobFinished`関数内で、finishedConditionがJobCompleteであり、かつ`job.Status.Succeeded > *job.Spec.Completions`の場合に発行される。具体的には`job_controller.go`の1538-1539行目で発行される。

**通知の受信者**：Kubernetes Event APIを通じてJobオブジェクトに関連付けられるため、`kubectl get events`やモニタリングツールを通じてクラスタ管理者が受信する。

**通知内容の概要**：「Too many succeeded pods running after completion count reached」というメッセージが含まれ、completions到達後に過剰な成功Podが存在することを通知する。

**期待されるアクション**：受信者はJobの実行結果を確認し、余剰なPodがデータの重複や不整合を引き起こしていないかを検証する。必要に応じてJobの設定（parallelism、completions等）の見直しを行う。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sync処理内で即座に発行） |
| 優先度 | 高（Warning） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

Jobオブジェクト自体がイベントの対象（InvolvedObject）となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | TooManySucceededPods |
| 発行元コンポーネント | job-controller |

### 本文テンプレート

```
Too many succeeded pods running after completion count reached
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本イベントは固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラー同期 | Jobのsync処理完了時 | spec.completions != nil かつ status.succeeded > spec.completions かつ finishedCondition == JobComplete | recordJobFinished関数内 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| spec.completionsがnil | Completionsが未設定の場合は判定が行われない |
| succeeded <= completions | 通常の完了の場合 |
| Job失敗 | finishedConditionがJobFailedの場合は本イベントではなく失敗イベントが発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[recordJobFinished呼び出し] --> B{finishedCond.Type == JobComplete?}
    B -->|Yes| C{spec.completions != nil?}
    B -->|No| D[失敗イベント発行]
    C -->|Yes| E{succeeded > completions?}
    C -->|No| F[Completed Event発行]
    E -->|Yes| G[TooManySucceededPods Event発行]
    E -->|No| F
    G --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Jobオブジェクト | completions、succeededの確認 | etcd経由 |

### テーブル別参照項目詳細

#### Jobオブジェクト

| 参照項目（フィールド名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.completions | 完了数の基準 | recordJobFinished時 |
| status.succeeded | 成功Pod数 | recordJobFinished時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Eventオブジェクト | INSERT | 警告イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Event発行失敗 | APIサーバー接続エラー | EventBroadcasterの内部リトライに依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

本イベントにはJobの名前とNamespaceのみが含まれ、機密情報は含まれない。

## 備考

- このイベントはCompletedイベント（1541行目）の直前に発行される
- 通常はレースコンディションにより発生する（Podの完了通知がコントローラーに遅延して到達するケースなど）
- Job自体は正常に完了として記録される（Completedイベントも発行される）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JobのCompletionsとSucceededの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `vendor/k8s.io/api/batch/v1/types.go` | JobSpec.Completions、JobStatus.Succeeded |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job_controller.go | `pkg/controller/job/job_controller.go` | recordJobFinished関数（1534-1548行目） |

**主要処理フロー**:
1. **1537行目**: `finishedCond.Type == batch.JobComplete`の判定
2. **1538行目**: `job.Spec.Completions != nil && job.Status.Succeeded > *job.Spec.Completions`の判定
3. **1539行目**: `recorder.Event`で"TooManySucceededPods"イベント発行
4. **1541行目**: `recorder.Event`で"Completed"イベント発行（TooManySucceededPodsの後に常に発行）

### プログラム呼び出し階層図

```
Controller.syncJob
    |
    +-- recordJobFinished (1534行目)
            |
            +-- succeeded > completions判定 (1538行目)
            |       |
            |       +-- recorder.Event "TooManySucceededPods" (1539行目)
            |
            +-- recorder.Event "Completed" (1541行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Job.spec.completions      --> recordJobFinished
Job.status.succeeded          succeeded > completions      --> Event "TooManySucceededPods"
finishedCondition             finishedCond == JobComplete   --> Event "Completed"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job_controller.go | `pkg/controller/job/job_controller.go` | ソース | Jobコントローラーのメインロジック |
