# 通知設計書 108-UnknownCompletionMode

## 概要

本ドキュメントは、KubernetesのJobコントローラーが発行する「UnknownCompletionMode」イベント通知の設計を記述する。Jobの完了モード（CompletionMode）が認識できない値に設定されている場合に警告として発行される。

### 本通知の処理概要

Jobコントローラーの同期処理開始時に、JobのCompletionModeがNonIndexedCompletionでもIndexedCompletionでもない未知の値に設定されている場合に発行されるWarningイベントである。

**業務上の目的・背景**：Jobの完了モードはNonIndexed（デフォルト）またはIndexedのいずれかである必要がある。未知の完了モードが設定された場合、コントローラーはJobの同期処理をスキップする。この通知により、運用者がJobの設定ミスを検知し、修正できるようにする。通常はAPIバリデーションで防がれるが、バージョン不整合時などに発生しうる。

**通知の送信タイミング**：JobコントローラーのsyncJob処理の冒頭で、CompletionModeの判定が行われ、認識できない値の場合に即座に発行される。具体的には`job_controller.go`の880-882行目で発行される。

**通知の受信者**：Kubernetes Event APIを通じてJobオブジェクトに関連付けられるため、`kubectl get events`やモニタリングツールを通じてクラスタ管理者が受信する。

**通知内容の概要**：「Skipped Job sync because completion mode is unknown」というメッセージが含まれ、未知の完了モードのためにJobの同期がスキップされたことを通知する。

**期待されるアクション**：受信者はJobのspec.completionModeフィールドを確認し、有効な値（NonIndexedまたはIndexed）に修正する。クラスタのバージョンと使用しているAPI機能の互換性を確認する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sync処理内で即座に発行） |
| 優先度 | 高（Warning） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

Jobオブジェクト自体がイベントの対象（InvolvedObject）となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | UnknownCompletionMode |
| 発行元コンポーネント | job-controller |

### 本文テンプレート

```
Skipped Job sync because completion mode is unknown
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本イベントは固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラー同期 | Jobのsync処理開始 | CompletionModeがnilでなく、NonIndexedでもIndexedでもない | syncJob冒頭の判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CompletionModeがnil | デフォルト（NonIndexed）として扱われる |
| CompletionModeがNonIndexed | 通常の非インデックス完了モード |
| CompletionModeがIndexed | インデックス完了モード |
| Jobが既に完了済み | 完了済みJobのsyncは冒頭で早期リターンされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncJob開始] --> B{Jobが完了済み?}
    B -->|Yes| C[早期リターン]
    B -->|No| D{CompletionMode判定}
    D -->|nil| E[通常処理]
    D -->|NonIndexed| E
    D -->|Indexed| E
    D -->|その他| F[UnknownCompletionMode Event発行]
    F --> G[syncスキップ リターン]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Jobオブジェクト | CompletionModeの確認 | etcd経由 |

### テーブル別参照項目詳細

#### Jobオブジェクト

| 参照項目（フィールド名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.completionMode | 完了モードの判定 | syncJob冒頭 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Eventオブジェクト | INSERT | 警告イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Event発行失敗 | APIサーバー接続エラー | EventBroadcasterの内部リトライに依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

本イベントにはJobの名前とNamespaceのみが含まれ、機密情報は含まれない。

## 備考

- 通常、APIバリデーションにより不正なCompletionModeの設定は拒否されるため、このイベントが発行されるのは稀
- 発行された場合、コントローラーはsyncをスキップして`nil`を返却するため、Jobは処理されない状態となる
- APIサーバーとコントローラーのバージョン不整合時に発生する可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JobのCompletionModeの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `vendor/k8s.io/api/batch/v1/types.go` | CompletionMode型（NonIndexedCompletion, IndexedCompletion） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job_controller.go | `pkg/controller/job/job_controller.go` | syncJob関数冒頭のCompletionMode判定（880-882行目） |

**主要処理フロー**:
1. **880行目**: `job.Spec.CompletionMode != nil && *job.Spec.CompletionMode != batch.NonIndexedCompletion && *job.Spec.CompletionMode != batch.IndexedCompletion`の3条件判定
2. **881行目**: `recorder.Event`で"UnknownCompletionMode"イベント発行
3. **882行目**: `return nil`でsyncをスキップ

### プログラム呼び出し階層図

```
Controller.syncJob
    |
    +-- CompletionMode判定 (880行目)
            |
            +-- recorder.Event "UnknownCompletionMode" (881行目)
            +-- return nil (882行目) -- sync処理スキップ
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Job.spec.completionMode   --> syncJob
  (未知の値)                    CompletionMode判定            --> Event "UnknownCompletionMode"
                                                             --> sync処理スキップ（return nil）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job_controller.go | `pkg/controller/job/job_controller.go` | ソース | Jobコントローラーのメインロジック |
