# 通知設計書 109-EvictionThresholdMet

## 概要

本ドキュメントは、kubeletのエビクションマネージャーが発行する「EvictionThresholdMet」イベント通知の設計を記述する。ノードのリソース使用量がエビクション閾値に到達した際に警告として発行される。

### 本通知の処理概要

kubeletのエビクションマネージャーがリソース監視のsynchronize処理内で、設定されたエビクション閾値を超えたリソースを検出し、そのリソースの回収を試みる際に発行されるWarningイベントである。

**業務上の目的・背景**：ノードのリソース（メモリ、ディスク、PID等）が枯渇するとノード全体が不安定になる。エビクションマネージャーはリソース使用量を監視し、閾値を超えた場合にPodをエビクト（退避）してリソースを回復する。この通知により、運用者がノードのリソース枯渇状態を検知し、キャパシティプランニングや問題のあるワークロードの特定を行えるようにする。

**通知の送信タイミング**：エビクションマネージャーのsynchronize処理内で、エビクション閾値が満たされ、grace periodも経過した後、リソース回収を開始する直前に発行される。具体的には`eviction_manager.go`の384行目で発行される。

**通知の受信者**：Kubernetes Event APIを通じてNodeオブジェクトに関連付けられるため、`kubectl get events --field-selector involvedObject.kind=Node`やモニタリングツールを通じてクラスタ管理者が受信する。

**通知内容の概要**：「Attempting to reclaim {リソース名}」というメッセージが含まれ、どのリソースの回収が試みられているかを通知する。

**期待されるアクション**：受信者はノードのリソース使用状況を確認し、必要に応じてワークロードの削減、ノードの追加、リソース制限の見直しを行う。特にメモリやディスクの使用量が高いPodを特定し、リソース要求/制限の適切な設定を行う。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（synchronize処理内で即座に発行） |
| 優先度 | 高（Warning） |
| リトライ | なし（Kubernetes Event APIの内部リトライに依存） |

### 送信先決定ロジック

Nodeオブジェクト（nodeRef）がイベントの対象（InvolvedObject）となる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | EvictionThresholdMet |
| 発行元コンポーネント | kubelet eviction manager |

### 本文テンプレート

```
Attempting to reclaim %s
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| %s | 回収対象のリソース名（memory, ephemeral-storage, pid等） | resourceToReclaim | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期監視 | synchronize処理（monitoringInterval間隔） | エビクション閾値超過かつgrace period経過 | thresholdsMetGracePeriodで判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 閾値未到達 | リソース使用量が閾値以下の場合 |
| Grace period未経過 | 閾値到達後、grace periodが未経過の場合 |
| ローカルストレージエビクションで対応済み | localStorageEvictionでPodがエビクトされた場合 |
| 設定された閾値が空 | thresholdsが空の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[synchronize開始] --> B[リソース使用量取得]
    B --> C[閾値判定 thresholdsMet]
    C --> D[Grace period判定]
    D --> E{閾値超過?}
    E -->|No| F[終了]
    E -->|Yes| G[閾値を優先度でソート]
    G --> H[回収対象リソース特定]
    H --> I[EvictionThresholdMet Event発行]
    I --> J[ノードレベルリソース回収試行]
    J --> K{回収成功?}
    K -->|Yes| L[終了]
    K -->|No| M[Pod選択・エビクト]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| ノードリソース統計 | リソース使用量の取得 | summaryProvider経由 |
| Podオブジェクト | エビクト対象Podの選択 | activePods経由 |

### テーブル別参照項目詳細

#### ノードリソース統計

| 参照項目 | 用途 | 取得条件 |
|---------|------|---------|
| memory.available | メモリ使用量 | synchronize時 |
| nodefs.available | ノードFSディスク使用量 | synchronize時 |
| imagefs.available | イメージFSディスク使用量 | synchronize時 |
| pid.available | PID使用量 | synchronize時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Eventオブジェクト | INSERT | 警告イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リソース統計取得失敗 | summaryProvider.Getエラー | エラーログ出力、次回synchronizeで再試行 |
| Event発行失敗 | APIサーバー接続エラー | EventBroadcasterの内部リトライに依存 |
| Podエビクト失敗 | killPodFuncエラー | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Event APIの内部リトライに依存 |
| リトライ間隔 | EventBroadcasterのデフォルト設定 |
| リトライ対象エラー | APIサーバー一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。monitoringInterval（デフォルト10秒）間隔で監視が行われる。

## セキュリティ考慮事項

本イベントにはノード名とリソース名のみが含まれ、機密情報は含まれない。

## 備考

- エビクションの優先度はbyEvictionPriorityでソートされる（376行目）
- ノードレベルリソース回収（Image GC、Container GC等）が先に試みられ、それでも不足する場合にPodエビクションが行われる
- 1回のsynchronizeサイクルで最大1つのPodがエビクトされる（421行目付近）
- hard evictionの場合、gracePeriodOverrideは1秒に設定される（immediateEvictionGracePeriodSeconds = 1）
- soft evictionの場合、MaxPodGracePeriodSecondsが使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エビクション閾値とシグナルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eviction_manager.go | `pkg/kubelet/eviction/eviction_manager.go` | managerImpl構造体（66-109行目）のフィールド |

**読解のコツ**: thresholdsMet、signalToRankFunc、signalToNodeReclaimFuncsが主要な内部状態である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | eviction_manager.go | `pkg/kubelet/eviction/eviction_manager.go` | Start関数（188-223行目）でsynchronizeループを開始 |
| 2-2 | eviction_manager.go | `pkg/kubelet/eviction/eviction_manager.go` | synchronize関数（248-446行目）がメインロジック |

**主要処理フロー**:
1. **295行目**: summaryProvider.Getでリソース統計取得
2. **315行目**: thresholdsMetで閾値判定
3. **345行目**: thresholdsMetGracePeriodでgrace period考慮
4. **377行目**: getReclaimableThresholdで回収対象特定
5. **384行目**: `recorder.Eventf`で"EvictionThresholdMet"イベント発行
6. **387行目**: reclaimNodeLevelResourcesでノードレベル回収試行
7. **408行目**: rank関数でPodをランキング
8. **421行目**: evictPodでPodエビクション

#### Step 3: Pod退避処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eviction_manager.go | `pkg/kubelet/eviction/eviction_manager.go` | evictPod関数（611-638行目）でのPod退避実行 |

### プログラム呼び出し階層図

```
managerImpl.Start (188行目)
    |
    +-- managerImpl.synchronize (248行目)
            |
            +-- summaryProvider.Get (295行目)
            +-- thresholdsMet (315行目)
            +-- thresholdsMetGracePeriod (345行目)
            +-- getReclaimableThreshold (377行目)
            +-- recorder.Eventf "EvictionThresholdMet" (384行目)
            +-- reclaimNodeLevelResources (387行目)
            |       |
            |       +-- imageGC / containerGC
            |
            +-- rank (408行目)
            +-- evictPod (439行目)
                    |
                    +-- killPodFunc
                    +-- recorder.AnnotatedEventf (620行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

summaryProvider           --> synchronize
  リソース統計                  makeSignalObservations
                              thresholdsMet
eviction.Config           --> thresholdsMetGracePeriod
  閾値設定                    getReclaimableThreshold      --> Event "EvictionThresholdMet"
                              reclaimNodeLevelResources
activePods                --> rank                         --> evictPod
                                                           --> Pod Phase=Failed
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| eviction_manager.go | `pkg/kubelet/eviction/eviction_manager.go` | ソース | エビクションマネージャーのメインロジック |
| helpers.go | `pkg/kubelet/eviction/helpers.go` | ソース | 閾値判定、ランキング等のヘルパー関数 |
| api/types.go | `pkg/kubelet/eviction/api/types.go` | ソース | エビクション関連の型定義 |
