# 通知設計書 11-Failed (MakePodDataDirectories)

## 概要

本ドキュメントは、KubernetesのkubeletがPodのデータディレクトリ作成に失敗した際に発行されるイベント通知「Failed (MakePodDataDirectories)」の設計を記述する。

### 本通知の処理概要

kubeletがPodの同期処理（syncPod）を実行する際に、Podの実行に必要なデータディレクトリ（Podディレクトリ、ボリュームディレクトリ、プラグインディレクトリ）を作成する。これらのディレクトリ作成に失敗した場合、本通知が発行される。

**業務上の目的・背景**：Podが正常に起動するためには、データディレクトリ（Pod用、ボリューム用、プラグイン用）がノード上のファイルシステムに作成される必要がある。ディスク容量不足やパーミッションの問題によりディレクトリ作成に失敗した場合、Podは起動できない。この通知は、クラスタ管理者やプラットフォームエンジニアに対してノードのファイルシステムに問題があることを示し、早急な対処を促す。

**通知の送信タイミング**：kubeletのsyncPod処理中、ミラーPodの調整後かつボリュームのアタッチ/マウント待機前に、`makePodDataDirs`関数が呼び出され、3つのディレクトリ（Pod基本ディレクトリ、ボリュームディレクトリ、プラグインディレクトリ）のいずれかの作成に失敗した時点で発行される。

**通知の受信者**：Pod作成を要求したユーザー、Namespace管理者、クラスタ管理者。Kubernetes Eventとして記録されるため、kubectl describe podやイベント監視ツールで確認できる。

**通知内容の概要**：「error making pod data directories: {エラー詳細}」という形式で、どのディレクトリ作成に失敗したか、およびそのエラー理由が通知される。

**期待されるアクション**：クラスタ管理者は、対象ノードのディスク容量やファイルシステムのパーミッションを確認し、問題を解消すべきである。必要に応じてノードのクリーンアップやPodの再スケジューリングを検討する。

## 通知種別

Kubernetes Event（クラスタ内部イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncPod処理フロー内で即時発行） |
| 優先度 | 高（Warning） |
| リトライ | 有（Pod Workerによる再同期で再試行） |

### 送信先決定ロジック

イベントの対象オブジェクトは、ディレクトリ作成に失敗したPodリソースそのものである。kubeletの `recorder.Eventf()` により、対象Podに紐づくEventオブジェクトがAPI Serverに記録される。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | Failed |
| Regarding | 対象Pod |
| 発行元 | kubelet |

### 本文テンプレート

```
error making pod data directories: {err}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | ディレクトリ作成時のエラーメッセージ | os.MkdirAll の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | syncPod実行 | makePodDataDirs関数がエラーを返却 | Pod/Volumes/Pluginsいずれかのディレクトリ作成失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ディレクトリが既に存在する場合 | os.IsExist(err)がtrueの場合はエラーとせず通知は発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncPod開始] --> B[ミラーPod調整]
    B --> C[makePodDataDirs呼び出し]
    C --> D[getPodDir作成]
    D --> E{MkdirAll成功?}
    E -->|成功| F[getPodVolumesDir作成]
    E -->|失敗 & !IsExist| G[Event発行: Failed]
    F --> H{MkdirAll成功?}
    H -->|成功| I[getPodPluginsDir作成]
    H -->|失敗 & !IsExist| G
    I --> J{MkdirAll成功?}
    J -->|成功| K[正常終了 - 次の処理へ]
    J -->|失敗 & !IsExist| G
    G --> L[syncPodがエラーを返却]
    L --> M[Pod Workerがリトライスケジュール]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd (Pod) | Pod UIDの参照 | ディレクトリパス生成に使用 |

### テーブル別参照項目詳細

#### Pod リソース

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| metadata.uid | ディレクトリパスの生成 | syncPod対象のPod |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd (Event) | INSERT | Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | "Failed" | イベント理由 |
| INSERT | message | "error making pod data directories: ..." | エラーメッセージ |
| INSERT | type | "Warning" | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディスク容量不足 | ノードのディスク使用率が100%に達した場合 | ノードのディスク空き容量を確保する |
| パーミッションエラー | kubeletプロセスにディレクトリ作成権限がない場合 | ファイルシステムのパーミッションを修正する |
| ファイルシステム破損 | 基盤となるファイルシステムが破損している場合 | ノードのファイルシステムを修復する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Pod Workerのresync間隔で無制限に再試行 |
| リトライ間隔 | resyncInterval + ジッタ |
| リトライ対象エラー | makePodDataDirs由来の全てのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event Recorderのデフォルトレート制限に準拠 |
| 1日あたり上限 | 制限なし（Event Recorderのバースト制限のみ） |

### 配信時間帯

制限なし。Pod同期処理の実行タイミングに依存する。

## セキュリティ考慮事項

- エラーメッセージにはノードのファイルシステムパスが含まれる可能性があるが、Kubernetes Eventとして記録されるため、当該Namespaceへのアクセス権限を持つユーザーのみが参照可能である。
- ディレクトリのパーミッションは0750で作成される（kubelet_pods.go:1054-1060行目）。

## 備考

- イベントのReason定数は `FailedToMakePodDataDirectories = "Failed"` であり、コンテナ作成失敗やイメージプル失敗と同じ "Failed" という文字列を使用している。区別はメッセージ本文で行う。
- 作成されるディレクトリは3つ: getPodDir（Pod基本ディレクトリ）、getPodVolumesDir（ボリュームディレクトリ）、getPodPluginsDir（プラグインディレクトリ）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベント定数の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 35行目: `FailedToMakePodDataDirectories = "Failed"` の定数定義を確認 |

**読解のコツ**: このReasonは `"Failed"` という汎用的な文字列であり、他のイベント（コンテナ作成失敗等）と同じ値であることに注意する。

#### Step 2: エントリーポイントを理解する

syncPod内でのディレクトリ作成呼び出しを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 2121-2126行目: makePodDataDirsの呼び出しとイベント発行 |

**主要処理フロー**:
1. **2122行目**: `kl.makePodDataDirs(pod)` を呼び出してディレクトリ作成を試行
2. **2123行目**: エラー時に `kl.recorder.Eventf()` でWarningイベントを発行
3. **2125行目**: `return false, err` でsyncPodがエラーを返却

#### Step 3: ディレクトリ作成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet_pods.go | `pkg/kubelet/kubelet_pods.go` | 1052-1064行目: makePodDataDirs関数の実装 |

**主要処理フロー**:
- **1053行目**: Pod UIDを取得
- **1054行目**: `os.MkdirAll(kl.getPodDir(uid), 0750)` でPod基本ディレクトリを作成
- **1057行目**: `os.MkdirAll(kl.getPodVolumesDir(uid), 0750)` でボリュームディレクトリを作成
- **1060行目**: `os.MkdirAll(kl.getPodPluginsDir(uid), 0750)` でプラグインディレクトリを作成

### プログラム呼び出し階層図

```
Kubelet.syncPod (kubelet.go:2122)
    |
    +-- Kubelet.makePodDataDirs (kubelet_pods.go:1052)
    |       |
    |       +-- os.MkdirAll(getPodDir(uid), 0750)
    |       +-- os.MkdirAll(getPodVolumesDir(uid), 0750)
    |       +-- os.MkdirAll(getPodPluginsDir(uid), 0750)
    |
    +-- recorder.Eventf (エラー時のイベント発行)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

Pod (metadata.uid) -----> makePodDataDirs -----> ディレクトリ作成 (成功時)
                                |
                                +-----> recorder.Eventf -----> Event (Warning/Failed) (失敗時)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncPod内でのmakePodDataDirs呼び出し |
| kubelet_pods.go | `pkg/kubelet/kubelet_pods.go` | ソース | makePodDataDirs関数の実装 |
