# 通知設計書 111-DeviceTaintManagerEviction

## 概要

本ドキュメントは、Kubernetes の device-taint-eviction コントローラが発行する DeviceTaintManagerEviction イベント通知の設計仕様を定義する。DRA（Dynamic Resource Allocation）デバイスに NoExecute 効果の Taint が設定された際に、当該デバイスを使用する Pod の削除マーキングまたは削除キャンセルを通知する。

### 本通知の処理概要

DeviceTaintManagerEviction は、DRA デバイスの Taint 変更に応じて Pod のエビクション（強制退去）状態を通知するイベントである。

**業務上の目的・背景**：DRA を利用して GPU やアクセラレータなどのデバイスを Pod に割り当てる環境において、デバイスに NoExecute Taint が設定された場合、当該デバイスを使用する Pod を安全に退去させる必要がある。本通知はそのエビクション処理の開始およびキャンセルをクラスタ管理者に可視化する。

**通知の送信タイミング**：DeviceTaintEviction コントローラが Pod の削除をマークする際（`emitPodDeletionEvent`）、および削除をキャンセルする際（`emitCancelPodDeletionEvent`）にイベントが発行される。具体的には、ResourceSlice 上のデバイスに NoExecute Taint が追加された後、Toleration の有無と TolerationSeconds を評価し、エビクション時刻に達した時点で発行される。

**通知の受信者**：Kubernetes イベントとして Pod オブジェクトに対して発行されるため、`kubectl describe pod` や `kubectl get events` で確認可能な全クラスタ管理者・オペレータが受信者となる。

**通知内容の概要**：Pod が DeviceTaintManager によって削除マーキングされたこと（"Marking for deletion"）、または削除がキャンセルされたこと（"Cancelling deletion"）を通知する。EventType は Normal であり、情報通知として機能する。

**期待されるアクション**：削除マーキング時は、影響を受けるワークロードの代替配置の確認、デバイス Taint の意図確認を行う。キャンセル時は、Taint が除去されたか Toleration が適用されたことを確認する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBroadcaster 経由） |
| 優先度 | 中 |
| リトライ | EventBroadcaster の内部リトライ機構に依存 |

### 送信先決定ロジック

イベントは Pod の ObjectReference（Name, Namespace, UID）を対象として発行される。EventBroadcaster が API Server の Events エンドポイントに記録する。受信者は Pod のイベントを監視する全てのクライアント（kubectl、監視ツール等）である。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
# 削除マーキング時
Marking for deletion

# 削除キャンセル時
Cancelling deletion
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| podRef.Name | 対象 Pod 名 | Pod オブジェクト | Yes |
| podRef.Namespace | 対象 Pod の Namespace | Pod オブジェクト | Yes |
| podRef.UID | 対象 Pod の UID | Pod オブジェクト | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | デバイス NoExecute Taint 追加 | Pod がエビクション対象と判定され、エビクション時刻に達した場合 | 削除マーキングイベント発行 |
| コントローラ処理 | デバイス Taint 除去 / Toleration 追加 | 以前エビクション対象だった Pod が対象外になった場合 | 削除キャンセルイベント発行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Pod が既に削除済み | DeletionTimestamp が設定済みの Pod にはイベントを発行しない |
| Pod が NotFound | Pod が既に存在しない場合はイベントを発行しない |
| recorder が nil | テスト環境など recorder が未設定の場合は発行しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ResourceSlice/DeviceTaintRule 変更検知] --> B[handleSliceChange / handleRuleChange]
    B --> C[claimEvictionTime 計算]
    C --> D{NoExecute Taint あり?}
    D -->|Yes| E[handlePod: evictPod]
    D -->|No| F[handlePod: cancelEvict]
    E --> G[workqueue にエビクション作業追加]
    G --> H[maybeDeletePod: エビクション時刻到達?]
    H -->|Yes| I[addConditionAndDeletePod]
    I --> J[emitPodDeletionEvent: Marking for deletion]
    H -->|No| K[再スケジュール]
    F --> L[emitCancelPodDeletionEvent: Cancelling deletion]
    J --> M[Pod 削除実行]
    M --> N[メトリクス記録]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | エビクション対象の Pod 情報取得 | API Server 経由 |
| ResourceClaim | デバイス割り当て状態の参照 | Informer キャッシュ |
| ResourceSlice | デバイス Taint 情報の参照 | Informer キャッシュ |
| DeviceTaintRule | Taint ルール定義の参照 | Informer キャッシュ（feature gate 有効時） |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.resourceClaims | Pod が使用する ResourceClaim の特定 | Pod が Node にスケジュール済み |
| spec.nodeName | Pod がスケジュール済みか判定 | 空でないこと |
| metadata.uid | Pod の一意識別 | エビクション対象の Pod |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Pod (status) | UPDATE | DisruptionTarget condition の追加 |
| Pod | DELETE | エビクション実行時の Pod 削除 |
| Event | INSERT | DeviceTaintManagerEviction イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | DeviceTaintManagerEviction | イベント理由 |
| INSERT | Event.message | "Marking for deletion" / "Cancelling deletion" | イベントメッセージ |
| INSERT | Event.type | Normal | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Pod NotFound | エビクション実行時に Pod が既に削除されている | エラーを抑制し、正常終了扱い |
| Pod UID 不一致 | 同名の別 Pod に置き換わっている | NotFound として処理終了 |
| API Server エラー | Pod status 更新や削除の API 呼び出し失敗 | workqueue のレート制限付きリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | workqueue の RateLimiting に基づく（上限なし、バックオフ制御） |
| リトライ間隔 | 指数バックオフ（DefaultControllerRateLimiter） |
| リトライ対象エラー | API Server への Pod 操作失敗全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コントローラが稼働中は常時発行可能）

## セキュリティ考慮事項

- イベントには Pod 名、Namespace、UID のみが含まれ、機密情報は含まれない
- イベントの閲覧は Kubernetes RBAC によって制御される
- DeviceTaintRule の操作には適切な RBAC 権限が必要

## 備考

- DeviceTaintManagerEviction は DRA（Dynamic Resource Allocation）機能の一部であり、feature gate `DRADeviceTaints` が有効な場合に完全に機能する
- DeviceTaintRule による Taint の場合は feature gate `DRADeviceTaintRules` も必要
- ruleStatusPeriod（10秒）の間隔で DeviceTaintRule のステータスが更新される
- メトリクス `pod_deletions_total` および `pod_deletions_latency` で削除統計を追跡可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DeviceTaintEviction コントローラの内部データ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | Controller 構造体（84-138行目）、evictionAndReason（252-255行目）、allocatedClaim（238-248行目）の定義 |

**読解のコツ**: `tainteviction.NamespacedObject` は Pod の参照キーとして使用される。`deletePodAt` マップがエビクション状態の中核データ構造である。

#### Step 2: エントリーポイントを理解する

コントローラの起動と初期化処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | New 関数（718-755行目）と Run 関数（759-1013行目） |

**主要処理フロー**:
1. **718行目**: New() でコントローラ初期化、Informer とメトリクスを設定
2. **759行目**: Run() で EventBroadcaster 開始、各 Informer のイベントハンドラ登録
3. **779行目**: recorder 初期化（`tc.name` = "device-taint-eviction" をコンポーネント名として使用）
4. **1005行目**: ワーカーゴルーチン起動

#### Step 3: イベント発行処理を理解する

Pod 削除イベントとキャンセルイベントの発行ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | emitPodDeletionEvent（1578-1590行目）と emitCancelPodDeletionEvent（1592-1604行目） |

**主要処理フロー**:
- **1589行目**: `tc.recorder.Eventf(ref, v1.EventTypeNormal, "DeviceTaintManagerEviction", "Marking for deletion")` でイベント発行
- **1603行目**: `tc.recorder.Eventf(ref, v1.EventTypeNormal, "DeviceTaintManagerEviction", "Cancelling deletion")` でキャンセルイベント発行

#### Step 4: エビクション判定ロジックを理解する

Pod がエビクション対象かどうかの判定フローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | podEvictionTime（1503-1568行目）、claimEvictionTime（1173-1229行目）、handlePod（1481-1501行目） |

**主要処理フロー**:
- **1503行目**: podEvictionTime() で Pod の全 ResourceClaim を走査
- **1173行目**: claimEvictionTime() で各デバイスの NoExecute Taint と Toleration を評価
- **1481行目**: handlePod() でエビクション要否を判定し evictPod() または cancelEvict() を呼び出す

### プログラム呼び出し階層図

```
Run()
    |
    +-- EventBroadcaster.NewRecorder() [recorder 初期化]
    |
    +-- handleSliceChange() / handleRuleChange() / handleClaimChange() / handlePodChange()
    |      |
    |      +-- claimEvictionTime() [Taint/Toleration 評価]
    |      |
    |      +-- handlePod()
    |             |
    |             +-- podEvictionTime() [エビクション時刻計算]
    |             |
    |             +-- evictPod() [workqueue に追加]
    |             |     +-- workqueue.Add/AddAfter
    |             |
    |             +-- cancelWorkWithEvent()
    |                   +-- cancelEvict()
    |                   +-- emitCancelPodDeletionEvent()
    |
    +-- worker()
           |
           +-- maybeDeletePod()
                  |
                  +-- addConditionAndDeletePod()
                         |
                         +-- emitPodDeletionEvent()
                         +-- PatchPodStatus() [DisruptionTarget condition]
                         +-- Pods().Delete()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ResourceSlice (Taint変更) --> handleSliceChange()                --> Event: "Marking for deletion"
                              |                                      (Pod ObjectReference)
DeviceTaintRule (Rule変更) --> handleRuleChange()                 --> Event: "Cancelling deletion"
                              |                                      (Pod ObjectReference)
ResourceClaim (割当変更)   --> handleClaimChange()                --> Pod Status: DisruptionTarget condition
                              |
Pod (スケジュール/変更)    --> handlePodChange()                  --> Pod DELETE (エビクション実行)
                              |
                              v
                         claimEvictionTime()
                              |
                              v
                         handlePod() --> evictPod() / cancelEvict()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | ソース | メインコントローラロジック、イベント発行 |
| device_taint_eviction_test.go | `pkg/controller/devicetainteviction/device_taint_eviction_test.go` | テスト | コントローラのユニットテスト |
| metrics/ | `pkg/controller/devicetainteviction/metrics/` | ソース | Pod 削除メトリクス定義 |
| tainteviction/ | `pkg/controller/tainteviction/` | ソース | TimedWorkerQueue 等の共通ユーティリティ |
| controller_policy.go | `plugin/pkg/auth/authorizer/rbac/bootstrappolicy/controller_policy.go` | 設定 | RBAC ポリシー定義 |
| controller_names.go | `cmd/kube-controller-manager/names/controller_names.go` | ソース | コントローラ名定義 |
