# 通知設計書 112-NodeControllerEviction

## 概要

本ドキュメントは、Kubernetes の node controller が発行する NodeControllerEviction イベント通知の設計仕様を定義する。ノードが応答不能と判断された際に、当該ノード上の Pod を削除マークする処理で発行される通知である。

### 本通知の処理概要

NodeControllerEviction は、ノードコントローラが応答不能ノード上の全 Pod を削除する際に、各 Pod に対して発行されるイベントである。

**業務上の目的・背景**：クラスタ内のノードが長時間応答しない場合、ノードコントローラは当該ノード上の Pod を強制削除する。本通知により、どの Pod がどのノードから退去処理の対象となったかをオペレータに明示し、障害対応の追跡を支援する。

**通知の送信タイミング**：ノードコントローラが `DeletePods` 関数を呼び出し、各 Pod の実際の削除 API を実行する直前に、Pod 単位でイベントが発行される。DaemonSet 管理の Pod や既に削除済みの Pod はスキップされる。

**通知の受信者**：Kubernetes イベントとして Pod オブジェクトに対して発行される。`kubectl describe pod` や監視システムを通じてクラスタ管理者・オペレータが確認する。

**通知内容の概要**：`Marking for deletion Pod {Pod名} from Node {ノード名}` というメッセージで、どの Pod がどのノードから削除マークされたかを通知する。EventType は Normal である。

**期待されるアクション**：ノードの障害状況を確認し、ノードの復旧またはクラスタからの除外を検討する。退去された Pod のワークロードが他ノードで正常に再スケジュールされているか確認する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 中 |
| リトライ | EventRecorder の内部機構に依存 |

### 送信先決定ロジック

対象ノード上の全 Pod を列挙し、以下の条件でフィルタリングした後、各 Pod に対してイベントを発行する：
- Pod の `spec.nodeName` が対象ノード名と一致すること
- Pod が DaemonSet に管理されていないこと
- Pod が既に削除処理中（DeletionGracePeriodSeconds 設定済み）でないこと

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Marking for deletion Pod {Pod名} from Node {ノード名}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pod.Name | 削除対象の Pod 名 | Pod オブジェクト | Yes |
| nodeName | Pod が稼働していたノード名 | DeletePods 引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | ノード応答不能検知 | ノードコントローラが Pod 削除を決定した場合 | 各 Pod に対してイベント発行後、削除 API 呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| DaemonSet 管理 Pod | DaemonSet に管理されている Pod はスキップ |
| 削除処理中の Pod | DeletionGracePeriodSeconds が既に設定済みの Pod はスキップ |
| 別ノードの Pod | spec.nodeName が対象ノードと一致しない Pod はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ノード応答不能検知] --> B[DeletePods 呼び出し]
    B --> C{Pod 一覧が空?}
    C -->|Yes| D[終了]
    C -->|No| E[DeletingAllPods イベント発行]
    E --> F[Pod ごとのループ]
    F --> G{nodeName 一致?}
    G -->|No| F
    G -->|Yes| H[SetPodTerminationReason]
    H --> I{削除処理中?}
    I -->|Yes| F
    I -->|No| J{DaemonSet 管理?}
    J -->|Yes| F
    J -->|No| K[NodeControllerEviction イベント発行]
    K --> L[Pod 削除 API 呼び出し]
    L --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | 対象ノード上の Pod 一覧 | 引数で渡される |
| DaemonSet | DaemonSet 管理 Pod のフィルタリング | DaemonSetLister 経由 |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.nodeName | 対象ノード上の Pod か判定 | 対象ノード名と一致 |
| deletionGracePeriodSeconds | 削除処理中か判定 | nil でないこと |
| status.reason | 終了理由の設定確認 | NodeUnreachable であること |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Pod (status) | UPDATE | 終了理由を NodeUnreachable に設定 |
| Pod | DELETE | Pod の削除 |
| Event | INSERT | NodeControllerEviction イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | NodeControllerEviction | イベント理由 |
| INSERT | Event.message | "Marking for deletion Pod {name} from Node {node}" | イベントメッセージ |
| INSERT | Event.type | Normal | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Pod NotFound | 削除時に Pod が既に存在しない | エラーをスキップし次の Pod へ |
| Status 更新 Conflict | Pod status の楽観ロック競合 | エラーリストに追加し、最終的にエラー返却 |
| 削除 API エラー | Pod 削除の API 呼び出し失敗 | エラーを返却し処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 呼び出し元のノードコントローラのリトライポリシーに依存 |
| リトライ間隔 | 呼び出し元に依存 |
| リトライ対象エラー | Conflict エラー以外の API エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには Pod 名とノード名のみが含まれ、機密情報は含まれない
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- DeletePods の最初に、ノード全体に対して "DeletingAllPods" イベントも発行される
- Pod の status.reason は "NodeUnreachable" に、status.message は "Node {nodeName} which was running pod {podName} is unresponsive" に設定される
- Taint ベースのエビクション（TaintManagerEviction）とは別のコードパスで発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ノードコントローラのユーティリティ関数群を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | controller_utils.go | `pkg/controller/util/node/controller_utils.go` | DeletePods 関数（45-98行目）の引数と戻り値 |

**読解のコツ**: DeletePods は独立したユーティリティ関数であり、ノードコントローラのライフサイクルコントローラから呼び出される。引数として Pod リスト、recorder、nodeName、nodeUID、DaemonSetLister を受け取る。

#### Step 2: エントリーポイントを理解する

DeletePods 関数の処理フローを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | controller_utils.go | `pkg/controller/util/node/controller_utils.go` | DeletePods（45-98行目）、SetPodTerminationReason（100-117行目） |

**主要処理フロー**:
1. **50-52行目**: Pod リストが空でなければ DeletingAllPods イベント発行
2. **63行目**: SetPodTerminationReason で Pod status を更新
3. **76行目**: DaemonSet 管理 Pod をスキップ
4. **82行目**: `recorder.Eventf(pod, v1.EventTypeNormal, "NodeControllerEviction", ...)` でイベント発行
5. **83行目**: Pod 削除 API 呼び出し

#### Step 3: 関連ヘルパー関数を理解する

ノードイベント記録やステータス変更の補助関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | controller_utils.go | `pkg/controller/util/node/controller_utils.go` | RecordNodeEvent（164-175行目）、MarkPodsNotReady（119-161行目） |

### プログラム呼び出し階層図

```
NodeLifecycleController (ノード応答不能検知)
    |
    +-- DeletePods()
           |
           +-- RecordNodeEvent("DeletingAllPods")  [ノード全体イベント]
           |
           +-- [Pod ループ]
                  |
                  +-- SetPodTerminationReason()  [status.reason = NodeUnreachable]
                  |
                  +-- daemonStore.GetPodDaemonSets()  [DaemonSet チェック]
                  |
                  +-- recorder.Eventf("NodeControllerEviction")  [Pod イベント発行]
                  |
                  +-- kubeClient.CoreV1().Pods().Delete()  [Pod 削除]
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ノード応答不能判定         --> DeletePods()                       --> Event: "DeletingAllPods" (Node)
Pod リスト                    |                                   --> Event: "NodeControllerEviction" (Pod)
nodeName, nodeUID             +-- SetPodTerminationReason()       --> Pod status 更新 (NodeUnreachable)
DaemonSetLister               +-- DaemonSet フィルタ             --> Pod DELETE
                              +-- Pod 削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| controller_utils.go | `pkg/controller/util/node/controller_utils.go` | ソース | DeletePods / SetPodTerminationReason / RecordNodeEvent |
| node_lifecycle_controller.go | `pkg/controller/nodelifecycle/node_lifecycle_controller.go` | ソース | ノードライフサイクルコントローラ（DeletePods の呼び出し元） |
| format/format.go | `pkg/kubelet/util/format/format.go` | ソース | Pod フォーマットユーティリティ |
| node/util.go | `pkg/util/node/` | ソース | NodeUnreachablePodReason 等の定数定義 |
