# 通知設計書 113-NodeNotReady

## 概要

本ドキュメントは、Kubernetes の node controller が Pod に対して発行する NodeNotReady イベント通知の設計仕様を定義する。ノードが Ready 状態でなくなった際に、当該ノード上の Pod の Ready condition を false に更新した後に発行される通知である。

### 本通知の処理概要

NodeNotReady（ノードコントローライベント）は、ノードコントローラが MarkPodsNotReady 処理でノード上の Pod の Ready ステータスを false に更新した際に、各 Pod に対して発行される警告イベントである。

**業務上の目的・背景**：ノードが NotReady 状態になった場合、当該ノード上で稼働する Pod のサービス提供能力に影響がある。本通知は Pod レベルでノードの不調を可視化し、Service のエンドポイントからの除外やロードバランサ設定の更新を促す。

**通知の送信タイミング**：ノードコントローラが MarkPodsNotReady を呼び出し、各 Pod の PodReady condition を false に更新した直後に発行される。Pod の status 更新が成功した場合のみイベントが記録される。

**通知の受信者**：Kubernetes イベントとして Pod オブジェクトに対して発行される。`kubectl describe pod` や監視システムで確認可能な全クラスタ管理者・オペレータが受信者となる。

**通知内容の概要**：`Node is not ready` というメッセージで、Pod が稼働するノードが Ready 状態でないことを通知する。EventType は Warning である。

**期待されるアクション**：ノードの障害原因を調査し、ノードの復旧または Pod の再スケジューリングを検討する。Service のトラフィック振り分けが自動的に更新されているか確認する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 高 |
| リトライ | EventRecorder の内部機構に依存 |

### 送信先決定ロジック

対象ノード上の全 Pod を列挙し、PodReady condition が存在する Pod に対して、condition を false に更新した後にイベントを発行する。nodeName が一致しない Pod はスキップされる。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Node is not ready
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | ノード NotReady 検知 | Pod の PodReady condition の更新が成功した場合 | MarkPodsNotReady 関数内で発行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| nodeName 不一致 | spec.nodeName が対象ノードと一致しない Pod はスキップ |
| PodReady condition なし | PodReady condition が存在しない Pod はスキップ |
| Status 更新失敗 | Pod status の更新に失敗した場合はイベント発行しない |
| Pod NotFound | Pod が既に削除されている場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ノード NotReady 検知] --> B[MarkPodsNotReady 呼び出し]
    B --> C[Pod ごとのループ]
    C --> D{nodeName 一致?}
    D -->|No| C
    D -->|Yes| E{PodReady condition あり?}
    E -->|No| C
    E -->|Yes| F[PodReady = False に設定]
    F --> G[Pod status 更新 API]
    G -->|成功| H[NodeNotReady イベント発行]
    G -->|NotFound| C
    G -->|エラー| I[エラーリストに追加]
    H --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | 対象ノード上の Pod 一覧 | 引数で渡される |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.nodeName | 対象ノード上の Pod か判定 | 対象ノード名と一致 |
| status.conditions | PodReady condition の確認 | type == PodReady |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Pod (status) | UPDATE | PodReady condition を False に更新 |
| Event | INSERT | NodeNotReady イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | NodeNotReady | イベント理由 |
| INSERT | Event.message | "Node is not ready" | イベントメッセージ |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Pod NotFound | status 更新時に Pod が既に削除されている | スキップして次の Pod へ |
| Status 更新エラー | API Server への更新呼び出し失敗 | エラーリストに追加、集約して返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 呼び出し元のノードコントローラに依存 |
| リトライ間隔 | 呼び出し元に依存 |
| リトライ対象エラー | Status 更新エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには機密情報は含まれない
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- 本通知はノードコントローラの MarkPodsNotReady 関数（No.113）から発行され、No.112（NodeControllerEviction）の DeletePods とは別のコードパスである
- PodReady condition の更新は `UpdatePodCondition` ユーティリティを使用し、既に False の場合は更新をスキップする
- `updateStatus` 後にイベントを記録することで、Pod が存在する状態でのみイベントが発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Pod の condition 構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | controller_utils.go | `pkg/controller/util/node/controller_utils.go` | MarkPodsNotReady 関数（119-161行目）の全体構造 |

**読解のコツ**: PodReady condition は `v1.PodReady` タイプで、Pod の準備状態を表す。この関数は condition を False に更新することで、Service エンドポイントからの除外を誘発する。

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | controller_utils.go | `pkg/controller/util/node/controller_utils.go` | 155行目の `recorder.Event(pod, v1.EventTypeWarning, "NodeNotReady", "Node is not ready")` |

**主要処理フロー**:
1. **126-130行目**: Pod リストをループし nodeName チェック
2. **134-137行目**: PodReady condition を検索
3. **139行目**: condition.Status を ConditionFalse に設定
4. **140行目**: UpdatePodCondition で変更があるか確認
5. **145行目**: API Server に status 更新
6. **155行目**: イベント発行（updateStatus 成功後）

### プログラム呼び出し階層図

```
NodeLifecycleController
    |
    +-- MarkPodsNotReady()
           |
           +-- [Pod ループ]
                  |
                  +-- UpdatePodCondition()  [PodReady = False]
                  |
                  +-- kubeClient.CoreV1().Pods().UpdateStatus()
                  |
                  +-- recorder.Event("NodeNotReady", "Node is not ready")
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ノード NotReady 判定       --> MarkPodsNotReady()                --> Event: "Node is not ready" (Pod)
Pod リスト                    |                                   --> Pod status 更新 (PodReady=False)
nodeName                      +-- condition 更新
                              +-- API 更新
                              +-- イベント記録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| controller_utils.go | `pkg/controller/util/node/controller_utils.go` | ソース | MarkPodsNotReady 関数、NodeNotReady イベント発行 |
| node_lifecycle_controller.go | `pkg/controller/nodelifecycle/node_lifecycle_controller.go` | ソース | MarkPodsNotReady の呼び出し元 |
| pod/util.go | `pkg/api/v1/pod/` | ソース | UpdatePodCondition ユーティリティ |
