# 通知設計書 114-FailedToListPods

## 概要

本ドキュメントは、Kubernetes の endpointslice-controller が発行する FailedToListPods イベント通知の設計仕様を定義する。EndpointSlice コントローラが Service に対応する Pod 一覧の取得に失敗した際に発行される警告通知である。

### 本通知の処理概要

FailedToListPods は、EndpointSlice コントローラが Service の同期処理（syncService）において、Service のセレクタに一致する Pod 一覧をローカルキャッシュから取得する際にエラーが発生した場合に、Service オブジェクトに対して発行される警告イベントである。

**業務上の目的・背景**：EndpointSlice コントローラは Service のセレクタに基づいて Pod を列挙し、対応する EndpointSlice を生成・更新する。Pod 一覧の取得に失敗すると EndpointSlice が正しく更新されず、Service へのトラフィックルーティングに影響が生じる可能性がある。本通知はその障害をオペレータに警告する。

**通知の送信タイミング**：syncService 関数内で `podLister.Pods(namespace).List(selector)` がエラーを返した時点で発行される。ローカルキャッシュからの取得であるため、通常は発生しにくい。

**通知の受信者**：Kubernetes イベントとして Service オブジェクトに対して発行される。`kubectl describe service` や監視システムで確認可能。

**通知内容の概要**：`Error listing Pods for Service {namespace}/{name}: {error}` というメッセージで、Pod 一覧取得の失敗理由を通知する。EventType は Warning である。

**期待されるアクション**：Informer キャッシュの状態を確認し、必要に応じてコントローラの再起動を検討する。通常運用では発生しにくいため、発生した場合はクラスタ全体の健全性を確認する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 高 |
| リトライ | syncService のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは syncService で処理中の Service オブジェクトに対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Error listing Pods for Service {namespace}/{name}: {error}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| service.Namespace | Service の Namespace | Service オブジェクト | Yes |
| service.Name | Service 名 | Service オブジェクト | Yes |
| err | エラー内容 | podLister.List の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Service 同期処理 | podLister.Pods().List() がエラーを返した場合 | Pod 一覧取得失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Pod 一覧取得成功 | エラーが発生しない場合はイベント発行しない |
| ExternalName Service | Type が ExternalName の Service は同期処理自体がスキップ |
| セレクタなし Service | セレクタが nil の Service は同期処理自体がスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Service 変更検知 / Pod 変更検知] --> B[serviceQueue に追加]
    B --> C[syncService 実行]
    C --> D[Service 取得]
    D --> E{ExternalName or セレクタなし?}
    E -->|Yes| F[スキップ]
    E -->|No| G[podLister.Pods.List]
    G -->|成功| H[EndpointSlice 同期処理]
    G -->|エラー| I[FailedToListPods イベント発行]
    I --> J[エラー返却 → リトライ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Service | 同期対象 Service の取得 | ServiceLister 経由 |
| Pod | セレクタに一致する Pod の列挙 | PodLister 経由（ローカルキャッシュ） |

### テーブル別参照項目詳細

#### Service

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.selector | Pod 一覧取得のラベルセレクタ | nil でないこと |
| spec.type | ExternalName チェック | ExternalName でないこと |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | FailedToListPods イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | FailedToListPods | イベント理由 |
| INSERT | Event.message | "Error listing Pods for Service ..." | エラー詳細含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Pod 一覧取得失敗 | Informer キャッシュのエラー | イベント発行後、エラー返却でリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回 |
| リトライ間隔 | 指数バックオフ（1s, 2s, 4s, ... 最大1000s） |
| リトライ対象エラー | syncService のエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには Service 名、Namespace、エラーメッセージが含まれる
- エラーメッセージに機密情報が含まれる可能性は低い
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- コメントに「ローカルキャッシュからの取得であるため、このエラーが発生することは基本的にない（basically impossible）」と記載されている
- 発生した場合は Informer の同期状態やメモリ不足などの深刻な問題を示唆する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EndpointSlice コントローラの構造体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | Controller 構造体（193-268行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | syncService 関数（368-451行目） |

**主要処理フロー**:
1. **406行目**: `podLabelSelector` を Service のセレクタから生成
2. **407行目**: `c.podLister.Pods(service.Namespace).List(podLabelSelector)` で Pod 一覧取得
3. **411-413行目**: エラー時に `FailedToListPods` イベント発行
4. **414行目**: エラー返却

### プログラム呼び出し階層図

```
serviceQueueWorker()
    |
    +-- processNextServiceWorkItem()
           |
           +-- syncService()
                  |
                  +-- serviceLister.Get()
                  |
                  +-- podLister.Pods().List()  ← エラー時にイベント発行
                  |     |
                  |     +-- eventRecorder.Eventf("FailedToListPods")
                  |
                  +-- endpointSliceLister.List()
                  |
                  +-- reconciler.Reconcile()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Service (セレクタ)         --> syncService()                     --> Event: "FailedToListPods" (Service)
                              |
                              +-- podLister.Pods().List()
                              |      (エラー発生)
                              +-- eventRecorder.Eventf()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | ソース | EndpointSlice コントローラ本体、syncService でイベント発行 |
| endpointslice_controller_test.go | `pkg/controller/endpointslice/endpointslice_controller_test.go` | テスト | コントローラのユニットテスト |
