# 通知設計書 115-FailedToListEndpointSlices

## 概要

本ドキュメントは、Kubernetes の endpointslice-controller が発行する FailedToListEndpointSlices イベント通知の設計仕様を定義する。EndpointSlice コントローラが Service に対応する EndpointSlice 一覧の取得に失敗した際に発行される警告通知である。

### 本通知の処理概要

FailedToListEndpointSlices は、EndpointSlice コントローラの syncService 処理において、Service に関連する EndpointSlice 一覧をローカルキャッシュから取得する際にエラーが発生した場合に発行されるイベントである。

**業務上の目的・背景**：EndpointSlice の一覧取得に失敗すると、コントローラは既存の EndpointSlice 状態を把握できず、正しい差分更新が行えない。本通知はこの障害状態をオペレータに警告し、Service のエンドポイント管理に問題が生じていることを知らせる。

**通知の送信タイミング**：syncService 関数内で `endpointSliceLister.EndpointSlices(namespace).List(selector)` がエラーを返した時点で発行される。ローカルキャッシュからの取得であるため、通常は発生しにくい。

**通知の受信者**：Kubernetes イベントとして Service オブジェクトに対して発行される。`kubectl describe service` や監視システムで確認可能。

**通知内容の概要**：`Error listing Endpoint Slices for Service {namespace}/{name}: {error}` というメッセージで、EndpointSlice 一覧取得の失敗理由を通知する。EventType は Warning である。

**期待されるアクション**：Informer キャッシュの状態を確認し、必要に応じてコントローラの再起動を検討する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 高 |
| リトライ | syncService のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは syncService で処理中の Service オブジェクトに対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Error listing Endpoint Slices for Service {namespace}/{name}: {error}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| service.Namespace | Service の Namespace | Service オブジェクト | Yes |
| service.Name | Service 名 | Service オブジェクト | Yes |
| err | エラー内容 | endpointSliceLister.List の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Service 同期処理 | endpointSliceLister.List() がエラーを返した場合 | EndpointSlice 一覧取得失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| EndpointSlice 一覧取得成功 | エラーが発生しない場合はイベント発行しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Service 変更検知] --> B[syncService 実行]
    B --> C[Pod 一覧取得成功]
    C --> D[endpointSliceLister.List]
    D -->|成功| E[EndpointSlice 同期処理]
    D -->|エラー| F[FailedToListEndpointSlices イベント発行]
    F --> G[エラー返却 → リトライ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Service | 同期対象 Service の取得 | ServiceLister 経由 |
| EndpointSlice | Service に関連する EndpointSlice の列挙 | EndpointSliceLister 経由 |

### テーブル別参照項目詳細

#### EndpointSlice

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| labels[discovery.LabelServiceName] | Service との関連付け | Service 名と一致 |
| labels[discovery.LabelManagedBy] | コントローラ管理チェック | ControllerName と一致 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | FailedToListEndpointSlices イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | FailedToListEndpointSlices | イベント理由 |
| INSERT | Event.message | "Error listing Endpoint Slices for Service ..." | エラー詳細含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| EndpointSlice 一覧取得失敗 | Informer キャッシュのエラー | イベント発行後、エラー返却でリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回 |
| リトライ間隔 | 指数バックオフ（1s, 2s, 4s, ... 最大1000s） |
| リトライ対象エラー | syncService のエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには Service 名、Namespace、エラーメッセージが含まれる
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- コメントに「ローカルキャッシュからの取得であるため、このエラーが発生することは基本的にない（basically impossible）」と記載されている
- endpointslicemirroring パッケージにも同名の定数（FailedToListEndpointSlices）が定義されているが、本通知は endpointslice-controller が発行するものである

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | Controller 構造体（193-268行目） |

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | syncService 関数（368-451行目）、特に420-428行目 |

**主要処理フロー**:
1. **416-419行目**: EndpointSlice のラベルセレクタを構築（LabelServiceName, LabelManagedBy）
2. **420行目**: `c.endpointSliceLister.EndpointSlices(namespace).List(esLabelSelector)` で一覧取得
3. **422-428行目**: エラー時に `FailedToListEndpointSlices` イベント発行

### プログラム呼び出し階層図

```
serviceQueueWorker()
    |
    +-- processNextServiceWorkItem()
           |
           +-- syncService()
                  |
                  +-- podLister.Pods().List()  [Pod 一覧取得]
                  |
                  +-- endpointSliceLister.EndpointSlices().List()  ← エラー時にイベント発行
                  |     |
                  |     +-- eventRecorder.Eventf("FailedToListEndpointSlices")
                  |
                  +-- reconciler.Reconcile()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Service                    --> syncService()                     --> Event: "FailedToListEndpointSlices"
EndpointSlice ラベル          |                                       (Service)
                              +-- endpointSliceLister.List()
                                   (エラー発生)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | ソース | syncService でイベント発行 |
| events.go | `pkg/controller/endpointslicemirroring/events.go` | ソース | 同名定数の定義（ミラーリングコントローラ用） |
