# 通知設計書 116-FailedToUpdateEndpointSlices

## 概要

本ドキュメントは、Kubernetes の endpointslice-controller が発行する FailedToUpdateEndpointSlices イベント通知の設計仕様を定義する。EndpointSlice コントローラが Service に対応する EndpointSlice の更新（Reconcile）に失敗した際に発行される警告通知である。

### 本通知の処理概要

FailedToUpdateEndpointSlices は、EndpointSlice コントローラの syncService 処理において、Reconciler による EndpointSlice の作成・更新・削除処理がエラーを返した場合に発行されるイベントである。

**業務上の目的・背景**：EndpointSlice の更新に失敗すると、Service のエンドポイント情報が実際の Pod 状態と乖離し、トラフィックルーティングに問題が生じる。本通知はこの更新失敗をオペレータに警告し、迅速な対応を促す。

**通知の送信タイミング**：syncService 関数内で `reconciler.Reconcile()` がエラーを返した時点で発行される。Reconcile は EndpointSlice の作成、更新、削除を含む包括的な同期処理であり、API Server への操作失敗が主な原因となる。

**通知の受信者**：Kubernetes イベントとして Service オブジェクトに対して発行される。`kubectl describe service` や監視システムで確認可能。

**通知内容の概要**：`Error updating Endpoint Slices for Service {namespace}/{name}: {error}` というメッセージで、更新失敗の理由を通知する。EventType は Warning である。

**期待されるアクション**：API Server の状態を確認し、EndpointSlice 操作に関する RBAC 権限やリソース制限を確認する。リトライで回復しない場合はコントローラの再起動を検討する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 高 |
| リトライ | syncService のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは syncService で処理中の Service オブジェクトに対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Error updating Endpoint Slices for Service {namespace}/{name}: {error}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| service.Namespace | Service の Namespace | Service オブジェクト | Yes |
| service.Name | Service 名 | Service オブジェクト | Yes |
| err | エラー内容 | reconciler.Reconcile の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Service 同期処理 | reconciler.Reconcile() がエラーを返した場合 | EndpointSlice 更新失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Reconcile 成功 | エラーが発生しない場合はイベント発行しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Service 変更検知] --> B[syncService 実行]
    B --> C[Pod 一覧取得]
    C --> D[EndpointSlice 一覧取得]
    D --> E[reconciler.Reconcile]
    E -->|成功| F[終了]
    E -->|エラー| G[FailedToUpdateEndpointSlices イベント発行]
    G --> H[エラー返却 → リトライ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Service | 同期対象 Service の取得 | ServiceLister 経由 |
| Pod | セレクタに一致する Pod の列挙 | PodLister 経由 |
| EndpointSlice | 既存 EndpointSlice の取得 | EndpointSliceLister 経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | FailedToUpdateEndpointSlices イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | FailedToUpdateEndpointSlices | イベント理由 |
| INSERT | Event.message | "Error updating Endpoint Slices for Service ..." | エラー詳細含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Reconcile 失敗 | EndpointSlice の CRUD 操作が API Server でエラー | イベント発行後、エラー返却でリトライ |
| 権限不足 | RBAC で EndpointSlice 操作が拒否 | RBAC 設定の確認が必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回 |
| リトライ間隔 | 指数バックオフ（1s, 2s, 4s, ... 最大1000s） |
| リトライ対象エラー | syncService のエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには Service 名、Namespace、エラーメッセージが含まれる
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- Reconcile は EndpointSlice の作成、更新、削除を包括的に行う処理であり、エラーの原因は多岐にわたる
- endpointslicemirroring パッケージにも同名の定数が定義されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | Controller 構造体と reconciler フィールド（231行目） |

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | syncService 関数（443-447行目） |

**主要処理フロー**:
1. **443行目**: `c.reconciler.Reconcile(logger, service, pods, endpointSlices, lastChangeTriggerTime)` 呼び出し
2. **444行目**: エラーチェック
3. **445-446行目**: `FailedToUpdateEndpointSlices` イベント発行

### プログラム呼び出し階層図

```
serviceQueueWorker()
    |
    +-- processNextServiceWorkItem()
           |
           +-- syncService()
                  |
                  +-- podLister.Pods().List()
                  |
                  +-- endpointSliceLister.List()
                  |
                  +-- reconciler.Reconcile()  ← エラー時にイベント発行
                        |
                        +-- eventRecorder.Eventf("FailedToUpdateEndpointSlices")
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Service + Pods + Slices    --> reconciler.Reconcile()            --> Event: "FailedToUpdateEndpointSlices"
                              |                                       (Service)
                              +-- EndpointSlice CRUD
                                   (エラー発生)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| endpointslice_controller.go | `pkg/controller/endpointslice/endpointslice_controller.go` | ソース | syncService でイベント発行 |
| events.go | `pkg/controller/endpointslicemirroring/events.go` | ソース | 同名定数の定義 |
