# 通知設計書 117-FailedToCreateEndpoint

## 概要

本ドキュメントは、Kubernetes の endpoint-controller が発行する FailedToCreateEndpoint イベント通知の設計仕様を定義する。Endpoint コントローラが新規 Endpoints リソースの作成に失敗した際に発行される警告通知である。

### 本通知の処理概要

FailedToCreateEndpoint は、endpoint-controller が Service に対応する Endpoints リソースを新規作成する API 呼び出しが失敗した場合に発行されるイベントである。

**業務上の目的・背景**：Endpoints リソースは Service へのトラフィックルーティングの基盤となる。新規作成に失敗すると、新しい Service に対するトラフィックが正しくルーティングされない。本通知はこの障害をオペレータに警告する。

**通知の送信タイミング**：syncService 関数内で `client.CoreV1().Endpoints(namespace).Create()` がエラーを返し、かつ Namespace 終了中（NamespaceTerminatingCause）でない場合に発行される。

**通知の受信者**：Kubernetes イベントとして Endpoints オブジェクトに対して発行される。`kubectl describe endpoints` や監視システムで確認可能。

**通知内容の概要**：`Failed to create endpoint for service {namespace}/{name}: {error}` というメッセージで、Endpoints 作成失敗の理由を通知する。EventType は Warning である。

**期待されるアクション**：API Server の状態、RBAC 権限、Namespace の状態を確認する。Forbidden エラーの場合は Namespace が終了中でないか確認する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 高 |
| リトライ | syncService のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは新規作成しようとした Endpoints オブジェクト（newEndpoints）に対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Failed to create endpoint for service {namespace}/{name}: {error}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| service.Namespace | Service の Namespace | Service オブジェクト | Yes |
| service.Name | Service 名 | Service オブジェクト | Yes |
| err | エラー内容 | Endpoints.Create の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Service 同期処理 | Endpoints.Create() がエラーを返した場合 | 新規 Endpoints 作成失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 作成成功 | エラーが発生しない場合はイベント発行しない |
| 更新ケース | 既存 Endpoints が存在する場合は更新パス（FailedToUpdateEndpoint）になる |
| Namespace 終了中の Forbidden | NamespaceTerminatingCause の Forbidden エラーの場合、nil を返して終了（イベント発行されるがリトライはしない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Service 変更検知] --> B[syncService 実行]
    B --> C[Endpoints 差分計算]
    C --> D{既存 Endpoints あり?}
    D -->|No| E[Endpoints.Create API]
    D -->|Yes| F[Endpoints.Update API]
    E -->|成功| G[終了]
    E -->|Forbidden| H{Namespace 終了中?}
    H -->|Yes| I[nil 返却（ドロップ）]
    H -->|No| J[FailedToCreateEndpoint イベント発行]
    E -->|その他エラー| J
    J --> K[エラー返却 → リトライ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Service | 同期対象 Service の取得 | ServiceLister 経由 |
| Pod | セレクタに一致する Pod の列挙 | PodLister 経由 |
| Endpoints | 既存 Endpoints の確認 | EndpointsLister 経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Endpoints | CREATE | 新規 Endpoints リソースの作成（失敗） |
| Event | INSERT | FailedToCreateEndpoint イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | FailedToCreateEndpoint | イベント理由 |
| INSERT | Event.message | "Failed to create endpoint for service ..." | エラー詳細含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Forbidden (Namespace 終了中) | Namespace が終了処理中 | nil 返却でリトライしない |
| Forbidden (その他) | RBAC 設定不備 | イベント発行後、エラー返却でリトライ |
| その他 API エラー | API Server エラー | イベント発行後、エラー返却でリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回 |
| リトライ間隔 | 指数バックオフ（5ms, 10ms, ... 最大82s） |
| リトライ対象エラー | Namespace 終了中の Forbidden 以外の全エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには Service 名、Namespace、エラーメッセージが含まれる
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- Forbidden エラーは主に2つの理由で発生する：(1) Namespace 終了中、(2) ポリシー設定の誤り
- Namespace 終了中の場合は作成が永続的に失敗するため、アイテムをドロップする（nil 返却）
- endpoint-controller の EventSource コンポーネント名は "endpoint-controller" である

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | endpoints_controller.go | `pkg/controller/endpoint/endpoints_controller.go` | Controller 構造体（132-180行目） |

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | endpoints_controller.go | `pkg/controller/endpoint/endpoints_controller.go` | syncService 関数（503-530行目） |

**主要処理フロー**:
1. **503行目**: `createEndpoints` フラグに基づき Create / Update を分岐
2. **505行目**: `client.CoreV1().Endpoints(namespace).Create()` 呼び出し
3. **510-521行目**: Forbidden エラーのハンドリング（Namespace 終了チェック）
4. **524-525行目**: `FailedToCreateEndpoint` イベント発行

### プログラム呼び出し階層図

```
worker()
    |
    +-- processNextWorkItem()
           |
           +-- syncService()
                  |
                  +-- Endpoints 差分計算
                  |
                  +-- createEndpoints == true の場合:
                  |     +-- client.CoreV1().Endpoints().Create()
                  |     |     (エラー時)
                  |     +-- eventRecorder.Eventf("FailedToCreateEndpoint")
                  |
                  +-- createEndpoints == false の場合:
                        +-- client.CoreV1().Endpoints().Update()
                              (エラー時)
                              +-- eventRecorder.Eventf("FailedToUpdateEndpoint")
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Service + Pods             --> syncService()                     --> Event: "FailedToCreateEndpoint"
Endpoints (既存なし)          |                                       (Endpoints)
                              +-- Endpoints.Create()
                                   (エラー発生)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| endpoints_controller.go | `pkg/controller/endpoint/endpoints_controller.go` | ソース | syncService で Endpoints 作成・イベント発行 |
| endpoints_controller_test.go | `pkg/controller/endpoint/endpoints_controller_test.go` | テスト | コントローラのユニットテスト |
