# 通知設計書 118-FailedToUpdateEndpoint

## 概要

本ドキュメントは、Kubernetes の endpoint-controller が発行する FailedToUpdateEndpoint イベント通知の設計仕様を定義する。Endpoint コントローラが既存 Endpoints リソースの更新に失敗した際に発行される警告通知である。

### 本通知の処理概要

FailedToUpdateEndpoint は、endpoint-controller が Service に対応する既存 Endpoints リソースを更新する API 呼び出しが失敗した場合に発行されるイベントである。

**業務上の目的・背景**：Endpoints リソースの更新に失敗すると、Service のエンドポイント情報が実際の Pod 状態と乖離し、古い Pod へのトラフィック転送や新しい Pod へのルーティング漏れが発生する。本通知はこの障害をオペレータに警告する。

**通知の送信タイミング**：syncService 関数内で `client.CoreV1().Endpoints(namespace).Update()` がエラーを返した時点で発行される。

**通知の受信者**：Kubernetes イベントとして Endpoints オブジェクトに対して発行される。`kubectl describe endpoints` や監視システムで確認可能。

**通知内容の概要**：`Failed to update endpoint {namespace}/{name}: {error}` というメッセージで、Endpoints 更新失敗の理由を通知する。EventType は Warning である。

**期待されるアクション**：API Server の状態、RBAC 権限を確認する。Conflict エラーの場合はリトライで自動回復する場合がある。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 高 |
| リトライ | syncService のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは更新しようとした Endpoints オブジェクト（newEndpoints）に対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Failed to update endpoint {namespace}/{name}: {error}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| service.Namespace | Service の Namespace | Service オブジェクト | Yes |
| service.Name | Service 名 | Service オブジェクト | Yes |
| err | エラー内容 | Endpoints.Update の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Service 同期処理 | Endpoints.Update() がエラーを返した場合 | 既存 Endpoints 更新失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 更新成功 | エラーが発生しない場合はイベント発行しない |
| 新規作成ケース | 既存 Endpoints がない場合は作成パス（FailedToCreateEndpoint）になる |
| 差分なし | Endpoints に変更がない場合は更新自体がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Service 変更検知] --> B[syncService 実行]
    B --> C[Endpoints 差分計算]
    C --> D{差分あり?}
    D -->|No| E[スキップ]
    D -->|Yes| F{既存 Endpoints あり?}
    F -->|No| G[Create パス]
    F -->|Yes| H[Endpoints.Update API]
    H -->|成功| I[終了]
    H -->|エラー| J[FailedToUpdateEndpoint イベント発行]
    J --> K[エラー返却 → リトライ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Service | 同期対象 Service の取得 | ServiceLister 経由 |
| Pod | セレクタに一致する Pod の列挙 | PodLister 経由 |
| Endpoints | 既存 Endpoints の確認 | EndpointsLister 経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Endpoints | UPDATE | 既存 Endpoints リソースの更新（失敗） |
| Event | INSERT | FailedToUpdateEndpoint イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | FailedToUpdateEndpoint | イベント理由 |
| INSERT | Event.message | "Failed to update endpoint ..." | エラー詳細含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| API Server エラー | Endpoints 更新の API 呼び出し失敗 | イベント発行後、エラー返却でリトライ |
| Conflict | 楽観ロック競合 | リトライで自動回復 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回 |
| リトライ間隔 | 指数バックオフ（5ms, 10ms, ... 最大82s） |
| リトライ対象エラー | 全エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには Service 名、Namespace、エラーメッセージが含まれる
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- 更新パスでは staleEndpointsTracker によって Informer キャッシュの陳腐化を検出する仕組みがある
- 更新結果の ResourceVersion が変わらない場合（webhook やtruncation によるnoop更新）は stale トラッキングをスキップする
- FailedToCreateEndpoint と同一の syncService 関数内で、createEndpoints フラグによって分岐する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | endpoints_controller.go | `pkg/controller/endpoint/endpoints_controller.go` | Controller 構造体（132-180行目）、staleEndpointsTracker フィールド（158行目） |

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | endpoints_controller.go | `pkg/controller/endpoint/endpoints_controller.go` | syncService 関数（506-530行目） |

**主要処理フロー**:
1. **455行目**: `createEndpoints` 判定（ResourceVersion が空か）
2. **508行目**: `client.CoreV1().Endpoints(namespace).Update()` 呼び出し
3. **510行目**: エラーチェック
4. **527行目**: `FailedToUpdateEndpoint` イベント発行

### プログラム呼び出し階層図

```
worker()
    |
    +-- processNextWorkItem()
           |
           +-- syncService()
                  |
                  +-- Endpoints 差分計算
                  |
                  +-- createEndpoints == false の場合:
                        +-- client.CoreV1().Endpoints().Update()
                              (エラー時)
                              +-- eventRecorder.Eventf("FailedToUpdateEndpoint")
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Service + Pods             --> syncService()                     --> Event: "FailedToUpdateEndpoint"
Endpoints (既存あり)          |                                       (Endpoints)
                              +-- Endpoints.Update()
                                   (エラー発生)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| endpoints_controller.go | `pkg/controller/endpoint/endpoints_controller.go` | ソース | syncService で Endpoints 更新・イベント発行 |
| endpoints_controller_test.go | `pkg/controller/endpoint/endpoints_controller_test.go` | テスト | コントローラのユニットテスト |
