# 通知設計書 119-InvalidIPAddress

## 概要

本ドキュメントは、Kubernetes の endpointslicemirroring-controller が発行する InvalidIPAddress イベント通知の設計仕様を定義する。EndpointSlice ミラーリングコントローラが Endpoints リソース内の無効な IP アドレスを検出した際に発行される警告通知である。

### 本通知の処理概要

InvalidIPAddress は、EndpointSlice ミラーリングコントローラの reconcile 処理において、Endpoints リソースのアドレスに含まれる IP アドレスが有効なIPv4/IPv6形式でない場合に発行されるイベントである。

**業務上の目的・背景**：EndpointSlice ミラーリングコントローラは、セレクタなし Service の Endpoints リソースを対応する EndpointSlice にミラーリングする。無効な IP アドレスが含まれている場合、その IP はミラーリングされず、一部のエンドポイントが EndpointSlice に反映されない。本通知はその状況をオペレータに警告する。

**通知の送信タイミング**：reconcile 関数内で Endpoints の各アドレスを処理する際に、`d.addAddress()` が false を返した（IP パースに失敗した）場合、無効アドレス数をカウントし、全サブセットの処理完了後に1回のイベントとして発行される。

**通知の受信者**：Kubernetes イベントとして Endpoints オブジェクトに対して発行される。`kubectl describe endpoints` や監視システムで確認可能。

**通知内容の概要**：`Skipped {count} invalid IP addresses when mirroring to EndpointSlices` というメッセージで、スキップされた無効 IP アドレスの数を通知する。EventType は Warning である。

**期待されるアクション**：Endpoints リソースに設定されている IP アドレスを確認し、無効な値を修正する。外部システムが REST API 経由で設定した IP アドレスの妥当性を検証する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 中 |
| リトライ | syncEndpoints のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは reconcile で処理中の Endpoints オブジェクトに対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
Skipped {count} invalid IP addresses when mirroring to EndpointSlices
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| numInvalidAddresses | スキップされた無効 IP アドレス数 | reconcile 内のカウンタ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Endpoints 同期処理 | 無効な IP アドレスが1つ以上検出された場合 | reconcile 関数内で発行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 無効アドレスなし | 全アドレスが有効な場合はイベント発行しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Endpoints 変更検知] --> B[syncEndpoints 実行]
    B --> C[reconcile 呼び出し]
    C --> D[サブセットごとのループ]
    D --> E[アドレスごとのループ]
    E --> F{IP パース成功?}
    F -->|Yes| G[EndpointSlice に追加]
    F -->|No| H[numInvalidAddresses++]
    H --> E
    G --> E
    E --> D
    D --> I{numInvalidAddresses > 0?}
    I -->|Yes| J[InvalidIPAddress イベント発行]
    I -->|No| K[次の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Endpoints | ミラーリング対象 Endpoints | EndpointsLister 経由 |
| Service | セレクタなし Service の確認 | ServiceLister 経由 |
| EndpointSlice | 既存ミラーリング EndpointSlice | EndpointSliceLister 経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | InvalidIPAddress イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | InvalidIPAddress | イベント理由 |
| INSERT | Event.message | "Skipped N invalid IP addresses ..." | 無効アドレス数含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効 IP アドレス | Endpoints の address.IP が有効なIPv4/IPv6でない | 警告イベント発行、該当アドレスをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回（syncEndpoints レベル） |
| リトライ間隔 | 指数バックオフ（1s, 2s, ... 最大100s） |
| リトライ対象エラー | reconcile のエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには無効 IP アドレスの数のみが含まれ、実際の IP アドレス値はイベントには含まれない
- 個別の無効 IP アドレスはログ（klog.Info）に記録される
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- 無効 IP アドレスの検出は `addAddress` 内の IP パース処理で行われる
- Addresses と NotReadyAddresses の両方が検査対象
- 無効アドレスは AddressesSkippedPerSync メトリクスにもカウントされる
- 個別の無効 IP は `klog.Info("Address in Endpoints is not a valid IP, it will not be mirrored to an EndpointSlice")` でログ出力される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.go | `pkg/controller/endpointslicemirroring/events.go` | InvalidIPAddress 定数定義（26-28行目） |
| 1-2 | reconciler.go | `pkg/controller/endpointslicemirroring/reconciler.go` | reconciler 構造体（39-59行目） |

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | reconciler.go | `pkg/controller/endpointslicemirroring/reconciler.go` | reconcile 関数（64-172行目）、特に69-121行目 |

**主要処理フロー**:
1. **69行目**: `numInvalidAddresses` カウンタ初期化
2. **80-93行目**: Addresses ループ、`d.addAddress()` で IP 検証
3. **95-108行目**: NotReadyAddresses ループ、同様に IP 検証
4. **89行目/105行目**: addAddress が false の場合 `numInvalidAddresses++`
5. **119-121行目**: `numInvalidAddresses > 0` の場合に InvalidIPAddress イベント発行

### プログラム呼び出し階層図

```
worker()
    |
    +-- processNextWorkItem()
           |
           +-- syncEndpoints()
                  |
                  +-- reconciler.reconcile()
                         |
                         +-- [サブセットループ]
                         |     +-- d.addAddress()  [IP パース]
                         |           (false = 無効 IP)
                         |
                         +-- eventRecorder.Eventf("InvalidIPAddress")
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Endpoints (Subsets)        --> reconcile()                       --> Event: "InvalidIPAddress"
  .Addresses                  |                                       (Endpoints)
  .NotReadyAddresses          +-- addAddress() [IP 検証]
                              +-- numInvalidAddresses カウント
                              +-- イベント発行 (> 0 の場合)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.go | `pkg/controller/endpointslicemirroring/events.go` | ソース | InvalidIPAddress 定数定義 |
| reconciler.go | `pkg/controller/endpointslicemirroring/reconciler.go` | ソース | reconcile でIP検証・イベント発行 |
| endpointslicemirroring_controller.go | `pkg/controller/endpointslicemirroring/endpointslicemirroring_controller.go` | ソース | コントローラ本体、syncEndpoints |
| metrics/ | `pkg/controller/endpointslicemirroring/metrics/` | ソース | AddressesSkippedPerSync メトリクス |
