# 通知設計書 12-NetworkNotReady

## 概要

本ドキュメントは、KubernetesのkubeletがPodの同期処理中にネットワークプラグインが未準備であることを検知した際に発行されるイベント通知「NetworkNotReady」の設計を記述する。

### 本通知の処理概要

kubeletのsyncPod処理において、Podのステータス設定後にネットワークプラグインの状態を確認し、ネットワークが準備できていない場合にHostNetworkを使用しないPodに対して本通知を発行する。

**業務上の目的・背景**：Kubernetesクラスタでは、CNI（Container Network Interface）プラグインがPodにネットワーク機能を提供する。CNIプラグインが未初期化、障害中、または設定不備の場合、Podはネットワーク接続を得られず起動できない。この通知は、ネットワークインフラストラクチャの問題をPodのイベントとして可視化し、クラスタ管理者による迅速な診断を支援する。

**通知の送信タイミング**：kubeletのsyncPod処理中、Podステータスの設定後かつシークレット/ConfigMapの登録前に、`kl.runtimeState.networkErrors()` がエラーを返した場合に発行される。HostNetworkを使用するPodはこのチェックをバイパスする。

**通知の受信者**：Pod作成を要求したユーザー、Namespace管理者、クラスタ管理者。Kubernetes Eventとして記録される。

**通知内容の概要**：「network is not ready: {ネットワークエラーの詳細}」という形式で、ネットワークプラグインのエラー状態が通知される。

**期待されるアクション**：クラスタ管理者はCNIプラグインの状態を確認し、必要に応じてプラグインの再起動やネットワーク設定の修正を行う。Pod Workerはネットワーク未準備エラーに対して短い間隔（backOffOnTransientErrorPeriod）でリトライを行うため、ネットワーク復旧後は自動的にPod起動が再試行される。

## 通知種別

Kubernetes Event（クラスタ内部イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncPod処理フロー内で即時発行） |
| 優先度 | 高（Warning） |
| リトライ | 有（Pod Workerによるbackoff付きリトライ） |

### 送信先決定ロジック

イベントの対象オブジェクトは、ネットワーク未準備により起動できないPodリソースである。kubeletの `recorder.Eventf()` により、対象Podに紐づくEventオブジェクトがAPI Serverに記録される。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | NetworkNotReady |
| Regarding | 対象Pod |
| 発行元 | kubelet |

### 本文テンプレート

```
network is not ready: {networkError}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| networkError | ネットワークプラグインのエラーメッセージ | runtimeState.networkErrors()の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | syncPod実行 | runtimeState.networkErrors()がエラーを返却 かつ PodがHostNetworkでない | ネットワークプラグインが未準備状態 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| HostNetwork Pod | kubecontainer.IsHostNetworkPod(pod)がtrueの場合、ネットワークチェックをスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncPod開始] --> B[Podステータス設定]
    B --> C[runtimeState.networkErrors呼び出し]
    C --> D{ネットワークエラー?}
    D -->|エラーなし| E[次の処理へ]
    D -->|エラーあり| F{HostNetwork Pod?}
    F -->|Yes| E
    F -->|No| G[Event発行: NetworkNotReady]
    G --> H[syncPodがエラーを返却]
    H --> I[Pod Worker: backOffOnTransientErrorPeriodでリトライ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd (Pod) | Pod spec.hostNetworkの確認 | HostNetworkチェック |

### テーブル別参照項目詳細

#### Pod リソース

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.hostNetwork | HostNetworkの判定 | syncPod対象のPod |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd (Event) | INSERT | Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | "NetworkNotReady" | イベント理由 |
| INSERT | message | "network is not ready: ..." | エラーメッセージ |
| INSERT | type | "Warning" | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| CNIプラグイン未初期化 | ノード起動直後でCNIプラグインが初期化完了していない | 自動リトライで復旧を待つ |
| CNIプラグイン障害 | CNIプラグインのプロセスがクラッシュした | CNIプラグインの再起動 |
| ネットワーク設定不備 | CNI設定ファイルが存在しないまたは不正 | CNI設定ファイルの修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（エラーが解消されるまで） |
| リトライ間隔 | backOffOnTransientErrorPeriod + ジッタ（pod_workers.go:1518-1520） |
| リトライ対象エラー | NetworkNotReadyErrorMsg を含むエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event Recorderのデフォルトレート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。Pod同期処理の実行タイミングに依存する。

## セキュリティ考慮事項

- ネットワークエラーの詳細情報がEventメッセージに含まれるが、ネットワーク構成の内部情報が露出する可能性がある。
- 当該Namespaceへのアクセス権限を持つユーザーのみがEventを参照可能。

## 備考

- Pod WorkerはNetworkNotReadyErrorMsgを含むエラーを特別に処理し、通常のbackoffよりも短い `backOffOnTransientErrorPeriod` でリトライする（pod_workers.go:1518-1520）。これはネットワーク復旧が比較的早期に見込まれるためである。
- HostNetworkを使用するPodはノードのネットワークスタックを直接使用するため、CNIプラグインの状態に影響されない。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エラー定数とイベント定数の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 36行目: `NetworkNotReady = "NetworkNotReady"` 定数 |
| 1-2 | errors.go | `pkg/kubelet/errors.go` | 22-23行目: `NetworkNotReadyErrorMsg = "network is not ready"` 定数 |

**読解のコツ**: イベントReasonとエラーメッセージは別々のファイルに定義されている。errors.goのメッセージはPod Workerでのリトライ判定にも使用される。

#### Step 2: エントリーポイントを理解する

syncPod内でのネットワークチェックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 2034-2038行目: ネットワークエラーチェックとイベント発行 |

**主要処理フロー**:
1. **2035行目**: `kl.runtimeState.networkErrors()` でネットワーク状態を確認
2. **2035行目**: `kubecontainer.IsHostNetworkPod(pod)` でHostNetworkをチェック
3. **2036行目**: Warningイベントを発行（形式: "%s: %v"）
4. **2037行目**: エラーを返却

#### Step 3: リトライロジックを理解する

Pod Workerでのネットワーク未準備エラーの特別処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | 1518-1520行目: NetworkNotReadyErrorMsgを含むエラーの特別なバックオフ処理 |

**主要処理フロー**:
- **1518行目**: `strings.Contains(syncErr.Error(), NetworkNotReadyErrorMsg)` でエラーメッセージを判定
- **1520行目**: `backOffOnTransientErrorPeriod` でリトライをスケジュール

### プログラム呼び出し階層図

```
Kubelet.syncPod (kubelet.go:2034)
    |
    +-- runtimeState.networkErrors()
    |       |
    |       +-- (ネットワークプラグインの状態確認)
    |
    +-- kubecontainer.IsHostNetworkPod(pod)
    |
    +-- recorder.Eventf (エラー時のイベント発行)
    |
    +-- (エラー返却) --> Pod Worker
                            |
                            +-- workQueue.Enqueue(backOffOnTransientErrorPeriod)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

Pod (spec.hostNetwork) ---> syncPod ネットワークチェック ---> Event (Warning/NetworkNotReady)
                                |
runtimeState -----------> networkErrors() 判定
                                |
                                +---> Pod Worker リトライスケジュール
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| errors.go | `pkg/kubelet/errors.go` | ソース | NetworkNotReadyErrorMsg定数の定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncPod内のネットワークチェックとイベント発行 |
| pod_workers.go | `pkg/kubelet/pod_workers.go` | ソース | ネットワーク未準備エラーのリトライ処理 |
