# 通知設計書 120-TooManyAddressesToMirror

## 概要

本ドキュメントは、Kubernetes の endpointslicemirroring-controller が発行する TooManyAddressesToMirror イベント通知の設計仕様を定義する。EndpointSlice ミラーリングコントローラが Endpoints リソース内のアドレス数が MaxEndpointsPerSubset を超過した際に発行される警告通知である。

### 本通知の処理概要

TooManyAddressesToMirror は、EndpointSlice ミラーリングコントローラの reconcile 処理において、EndpointSubset のアドレス数が maxEndpointsPerSubset の上限を超過した場合に発行されるイベントである。

**業務上の目的・背景**：EndpointSlice ミラーリングでは、EndpointSubset と EndpointSlice の 1:1 マッピングを維持するため、各サブセットのアドレス数に上限（maxEndpointsPerSubset）がある。この上限を超えるアドレスはミラーリングされず、一部のエンドポイントが EndpointSlice に反映されない。本通知はそのスキップされたアドレスの存在をオペレータに警告する。

**通知の送信タイミング**：reconcile 関数内で全サブセットのアドレス処理が完了した後、無効 IP アドレスを除いたスキップ数が0より大きい場合に発行される。具体的には `addressesSkipped > numInvalidAddresses` の場合に発行される。

**通知の受信者**：Kubernetes イベントとして Endpoints オブジェクトに対して発行される。`kubectl describe endpoints` や監視システムで確認可能。

**通知内容の概要**：`A max of {max} addresses can be mirrored to EndpointSlices per Endpoints subset. {skipped} addresses were skipped` というメッセージで、上限値とスキップ数を通知する。EventType は Warning である。

**期待されるアクション**：Endpoints リソースのアドレス数を確認し、サブセットの分割や不要アドレスの削除を検討する。MaxEndpointsPerSubset の値が適切か確認する。

## 通知種別

Kubernetes Event（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventRecorder 経由） |
| 優先度 | 中 |
| リトライ | syncEndpoints のリトライ機構に依存（最大15回） |

### 送信先決定ロジック

イベントは reconcile で処理中の Endpoints オブジェクトに対して発行される。

## 通知テンプレート

### メール通知の場合

本通知は Kubernetes Event であり、メール通知には該当しない。

### 本文テンプレート

```
A max of {maxEndpointsPerSubset} addresses can be mirrored to EndpointSlices per Endpoints subset. {addressesSkipped} addresses were skipped
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| r.maxEndpointsPerSubset | 1サブセットあたりの最大アドレス数 | reconciler 設定値 | Yes |
| addressesSkipped | スキップされたアドレス数 | reconcile 内のカウンタ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | Endpoints 同期処理 | addressesSkipped > numInvalidAddresses の場合 | 上限超過によるスキップが発生した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| スキップなし | アドレス数が上限以下の場合はイベント発行しない |
| 無効IPのみ | スキップが全て無効 IP アドレスによるものの場合は発行しない（InvalidIPAddress イベントのみ発行） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Endpoints 変更検知] --> B[syncEndpoints 実行]
    B --> C[reconcile 呼び出し]
    C --> D[サブセットごとのループ]
    D --> E[アドレスごとのループ]
    E --> F{totalAddressesAdded >= maxEndpointsPerSubset?}
    F -->|Yes| G[break: 上限到達]
    F -->|No| H{IP 有効?}
    H -->|Yes| I[EndpointSlice に追加]
    H -->|No| J[numInvalidAddresses++]
    E --> K[addressesSkipped += 残りアドレス]
    D --> L{addressesSkipped > numInvalidAddresses?}
    L -->|Yes| M[TooManyAddressesToMirror イベント発行]
    L -->|No| N[次の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Endpoints | ミラーリング対象 Endpoints | EndpointsLister 経由 |
| Service | セレクタなし Service の確認 | ServiceLister 経由 |
| EndpointSlice | 既存ミラーリング EndpointSlice | EndpointSliceLister 経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | TooManyAddressesToMirror イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.reason | TooManyAddressesToMirror | イベント理由 |
| INSERT | Event.message | "A max of N addresses can be mirrored ..." | 上限値とスキップ数含む |
| INSERT | Event.type | Warning | EventType |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| アドレス超過 | EndpointSubset のアドレス数が上限超過 | 警告イベント発行、超過分をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大15回（syncEndpoints レベル） |
| リトライ間隔 | 指数バックオフ（1s, 2s, ... 最大100s） |
| リトライ対象エラー | reconcile のエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event API のレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントには上限値とスキップ数のみが含まれ、機密情報は含まれない
- 閲覧は Kubernetes RBAC によって制御される

## 備考

- maxEndpointsPerSubset のデフォルト値は EndpointSlice ミラーリングコントローラの起動パラメータで設定される
- 無効 IP アドレスのスキップ数と上限超過によるスキップ数は AddressesSkippedPerSync メトリクスに合算で記録される
- Addresses（Ready）と NotReadyAddresses の両方が上限の計算対象に含まれる
- `totalAddresses = len(subset.Addresses) + len(subset.NotReadyAddresses)` で合計アドレス数が計算される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.go | `pkg/controller/endpointslicemirroring/events.go` | TooManyAddressesToMirror 定数定義（29-32行目） |
| 1-2 | reconciler.go | `pkg/controller/endpointslicemirroring/reconciler.go` | reconciler 構造体（39-59行目）、maxEndpointsPerSubset フィールド（54行目） |

#### Step 2: イベント発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | reconciler.go | `pkg/controller/endpointslicemirroring/reconciler.go` | reconcile 関数（64-172行目）、特に77-130行目 |

**主要処理フロー**:
1. **70行目**: `addressesSkipped` カウンタ初期化
2. **77行目**: `totalAddresses` 計算（Addresses + NotReadyAddresses）
3. **78行目**: `totalAddressesAdded` カウンタ初期化
4. **84行目**: `totalAddressesAdded >= maxEndpointsPerSubset` で break 判定
5. **99行目**: NotReadyAddresses でも同様の break 判定
6. **110行目**: `addressesSkipped += totalAddresses - totalAddressesAdded`
7. **126行目**: `addressesSkipped > numInvalidAddresses` の場合にイベント発行
8. **128-129行目**: `TooManyAddressesToMirror` イベント発行

### プログラム呼び出し階層図

```
worker()
    |
    +-- processNextWorkItem()
           |
           +-- syncEndpoints()
                  |
                  +-- reconciler.reconcile()
                         |
                         +-- [サブセットループ]
                         |     +-- [Addresses ループ]
                         |     |     +-- maxEndpointsPerSubset チェック → break
                         |     |     +-- addAddress()
                         |     |
                         |     +-- [NotReadyAddresses ループ]
                         |     |     +-- maxEndpointsPerSubset チェック → break
                         |     |     +-- addAddress()
                         |     |
                         |     +-- addressesSkipped 計算
                         |
                         +-- eventRecorder.Eventf("TooManyAddressesToMirror")
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Endpoints (Subsets)        --> reconcile()                       --> Event: "TooManyAddressesToMirror"
  .Addresses                  |                                       (Endpoints)
  .NotReadyAddresses          +-- maxEndpointsPerSubset チェック
maxEndpointsPerSubset         +-- addressesSkipped 計算
                              +-- イベント発行 (スキップ > 無効IP の場合)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.go | `pkg/controller/endpointslicemirroring/events.go` | ソース | TooManyAddressesToMirror 定数定義 |
| reconciler.go | `pkg/controller/endpointslicemirroring/reconciler.go` | ソース | reconcile で上限チェック・イベント発行 |
| endpointslicemirroring_controller.go | `pkg/controller/endpointslicemirroring/endpointslicemirroring_controller.go` | ソース | コントローラ本体、maxEndpointsPerSubset 設定 |
| metrics/ | `pkg/controller/endpointslicemirroring/metrics/` | ソース | AddressesSkippedPerSync メトリクス |
