# 通知設計書 122-NoPods

## 概要

本ドキュメントは、Kubernetes の disruption-controller が発行する `NoPods` イベント通知の設計を記述する。PodDisruptionBudget（PDB）に一致するPodが見つからない場合、またはPod取得に失敗した場合に発行されるイベントである。

### 本通知の処理概要

本通知は、PodDisruptionBudget コントローラが PDB の同期処理（trySync）を実行する際に、PDBのセレクタに一致するPodが0件であるか、Pod取得自体が失敗した場合に発行される。

**業務上の目的・背景**：PDBはPodの可用性を保護するためのリソースであるが、一致するPodが存在しない場合、PDBは実質的に機能しない。この状態をクラスタ管理者に通知し、PDBのセレクタ設定やアプリケーションのデプロイ状況を確認させることが目的である。

**通知の送信タイミング**：trySync関数の中で getPodsForPdb が呼ばれ、Podリストの取得に失敗した場合（Warningイベント）、または取得は成功したがPodが0件の場合（Normalイベント）に発行される。

**通知の受信者**：Kubernetes Event として PDB オブジェクトに対して記録される。`kubectl describe pdb` や `kubectl get events` で確認でき、クラスタ管理者が参照する。

**通知内容の概要**：Pod取得に失敗した場合はエラーメッセージ付きのWarning、Podが0件の場合は「No matching pods found」というNormalイベントが記録される。

**期待されるアクション**：クラスタ管理者はPDBのセレクタが正しいか確認し、対象のDeployment/StatefulSetが正しくデプロイされているかを検証する。

## 通知種別

Kubernetes Event（Normal または Warning イベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（イベント記録） |
| 優先度 | 中（Normal/Warning） |
| リトライ | なし（イベント記録のため） |

### 送信先決定ロジック

PDBオブジェクトに対してイベントが記録される。PDBの Namespace/Name を基に関連付けられる。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventであり、メール送信は行わない。

### 本文テンプレート

```
# Pod取得失敗時（Warning）
Failed to get pods: <error message>

# Pod 0件時（Normal）
No matching pods found
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| error | Pod取得時のエラーメッセージ | getPodsForPdb戻り値 | Yes（エラー時のみ） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | PDB同期（trySync） | getPodsForPdbがエラーを返す | Warning: Pod取得失敗 |
| コントローラ処理 | PDB同期（trySync） | getPodsForPdbが空リストを返す | Normal: Podなし |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Podが1件以上存在 | 正常ケースのためNoPods イベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PDB同期トリガー] --> B[trySync開始]
    B --> C[getPodsForPdb呼び出し]
    C --> D{結果}
    D -->|エラー| E[Warning NoPods - Failed to get pods]
    D -->|0件| F[Normal NoPods - No matching pods found]
    D -->|1件以上| G[正常処理続行]
    E --> H[エラー返却]
    F --> I[getExpectedPodCount続行]
    G --> I
    H --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PodDisruptionBudget（API リソース） | 同期対象のPDB取得 | pdbLister経由 |
| Pod（API リソース） | PDBに一致するPodの検索 | podLister + セレクタ照合 |

### テーブル別参照項目詳細

#### PodDisruptionBudget

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.selector | Podマッチングのセレクタ | PDB同期時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event（API リソース） | INSERT | NoPods イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | Normal or Warning / NoPods | Kubernetes Event APIを通じて記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Pod取得失敗 | getPodsForPdbがエラーを返す | Warning イベント発行後、エラーを上位に返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | コントローラのワークキューによる再試行 |
| リトライ間隔 | 指数バックオフ（ワークキューのデフォルト） |
| リトライ対象エラー | getPodsForPdb失敗時 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし（Event APIの仕様に依存） |

### 配信時間帯

特に制限なし。コントローラループの実行タイミングに依存する。

## セキュリティ考慮事項

本イベントにはPDB名、エラーメッセージが含まれるが、機密情報は含まれない。Kubernetes RBAC によりイベントの閲覧権限が制御される。

## 備考

- NoPods イベントは2つのケース（Warning/Normal）で発行され、EventTypeが異なる点に注意
- Pod取得失敗はAPI Server との通信障害などが原因となりうる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | disruption.go | `pkg/controller/disruption/disruption.go` | DisruptionController構造体（81-120行目）、特にpdbListerとpodListerの役割 |

**読解のコツ**: pdbLister と podLister がインフォーマーキャッシュを利用している点を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | disruption.go | `pkg/controller/disruption/disruption.go` | trySync関数（735-772行目）がPDB同期のメインロジック |

**主要処理フロー**:
1. **737行目**: getPodsForPdb(pdb) でPDBに一致するPodを取得
2. **738-740行目**: エラー時に Warning NoPods イベント発行
3. **742-743行目**: Pod 0件時に Normal NoPods イベント発行

#### Step 3: Pod取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | disruption.go | `pkg/controller/disruption/disruption.go` | getPodsForPdb関数（629行目付近）でPDBセレクタによるPod検索 |

### プログラム呼び出し階層図

```
DisruptionController.sync
    |
    +-- trySync (735行目)
           |
           +-- getPodsForPdb (737行目)
           |      +-- podLister.Pods(namespace).List(selector)
           |
           +-- recorder.Eventf("NoPods") (739行目 or 743行目)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

PDB同期キュー ───> trySync ───> getPodsForPdb ───> Event記録
                                                   (NoPods)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| disruption.go | `pkg/controller/disruption/disruption.go` | ソース | DisruptionControllerの本体、trySync/getPodsForPdb |
| disruption_test.go | `pkg/controller/disruption/disruption_test.go` | テスト | NoPods イベントのテスト |
