# 通知設計書 125-NotDeleted

## 概要

本ドキュメントは、Kubernetes の disruption-controller が発行する `NotDeleted` イベント通知の設計を記述する。PDBが削除を期待していたPodが、指定のタイムアウト（2分）以内に削除されなかった場合に発行される警告イベントである。

### 本通知の処理概要

本通知は、PDBの `Status.DisruptedPods` マップに記録されたPodが、DeletionTimeout（2分）以内に削除されなかった場合に発行される。PDBはPodのエビクション（退避）を許可した際にDisruptedPodsにPodを記録するが、実際に削除されなかった場合にこのイベントで通知する。

**業務上の目的・背景**：PDBはPodのエビクションを許可する際にDisruptedPodsにタイムスタンプとともに記録する。一定時間内に削除されない場合、エビクションが実際には行われなかった可能性があり、PDBのステータスが不正確になる。この警告により、管理者はエビクション処理の問題を検知できる。

**通知の送信タイミング**：buildDisruptedPodMap関数内で、DisruptedPodsに記録されたPodの予想削除時刻（記録時刻 + 2分）が現在時刻を過ぎており、かつPodにDeletionTimestampが設定されていない場合に発行される。

**通知の受信者**：Kubernetes Event として Pod オブジェクトに対して記録される。クラスタ管理者が参照する。

**通知内容の概要**：どのPDBがPodの削除を期待していたか（PDB名）が記録される。

**期待されるアクション**：クラスタ管理者は、エビクション処理が正常に機能しているか、対象Podが削除をブロックしている原因を調査する。

## 通知種別

Kubernetes Event（Warning イベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（イベント記録） |
| 優先度 | 中（Warning） |
| リトライ | なし |

### 送信先決定ロジック

Podオブジェクトに対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventであり、メール送信は行わない。

### 本文テンプレート

```
Pod was expected by PDB <Namespace>/<Namespace> to be deleted but it wasn't
```

注意：ソースコードの966-967行目では `pdb.Namespace` が2回使用されており、PDB名ではなくNamespaceが2回表示されるバグの可能性がある。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Namespace | PDBの名前空間 | pdb.Namespace | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | PDB同期（trySync） | DisruptedPodsの予想削除時刻を超過し、かつPodにDeletionTimestampがない | buildDisruptedPodMap内で検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| PodにDeletionTimestamp設定済み | Podが削除処理中の場合はスキップ |
| 予想削除時刻が未到達 | タイムアウト前の場合は再チェックをスケジュール |
| DisruptedPodsにPodが未登録 | Pod名がDisruptedPodsマップに存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PDB同期トリガー] --> B[trySync開始]
    B --> C[buildDisruptedPodMap]
    C --> D{各Pod確認}
    D -->|DeletionTimestamp設定済み| E[スキップ - 削除中]
    D -->|DisruptedPodsに未登録| F[スキップ - 対象外]
    D -->|タイムアウト超過| G[Warning Eventf NotDeleted]
    D -->|タイムアウト前| H[recheckTimeを更新]
    G --> I[DisruptedPodsから除外]
    E --> J[終了]
    F --> J
    H --> J
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PodDisruptionBudget（API リソース） | Status.DisruptedPods マップの取得 | pdbLister経由 |
| Pod（API リソース） | DeletionTimestamp の確認 | podLister経由 |

### テーブル別参照項目詳細

#### PodDisruptionBudget

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| status.disruptedPods | エビクション許可されたPodの一覧とタイムスタンプ | PDB同期時 |

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| metadata.deletionTimestamp | Pod削除状態の確認 | DisruptedPodsに登録されたPod |
| metadata.name | Pod識別 | DisruptedPodsマップのキー |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event（API リソース） | INSERT | Warning イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | Warning / NotDeleted | Kubernetes Event APIを通じて記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 本イベント自体がエラー検出の通知 | DisruptedPodsマップから該当エントリを除外して処理続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

特に制限なし。

## セキュリティ考慮事項

本イベントにはPDB名とNamespaceが含まれるが、機密情報は含まれない。

## 備考

- DeletionTimeoutは2分（定数: 59-69行目）
- ソースコード966-967行目で `pdb.Namespace` が2回使われており、本来は `pdb.Namespace, pdb.Name` であるべき可能性がある（バグの可能性）
- タイムアウト前のPodはrecheckTimeに登録され、後で再チェックされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | disruption.go | `pkg/controller/disruption/disruption.go` | DeletionTimeout定数（59-69行目）の定義とその意味 |

**読解のコツ**: DeletionTimeoutは2分であり、Pod追加からこの時間内に削除されることが期待される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | disruption.go | `pkg/controller/disruption/disruption.go` | buildDisruptedPodMap関数（944-976行目）がDisruptedPodsマップを構築 |

**主要処理フロー**:
1. **945行目**: pdb.Status.DisruptedPods を取得
2. **952-953行目**: 各Podを確認、DeletionTimestamp があればスキップ
3. **957-958行目**: DisruptedPodsマップでPod名を検索
4. **962行目**: 予想削除時刻 = disruptionTime + DeletionTimeout を計算
5. **963行目**: 現在時刻との比較
6. **966行目**: タイムアウト超過時に recorder.Eventf("NotDeleted") 発行
7. **969-972行目**: タイムアウト前ならrecheckTimeを更新しresultに追加

### プログラム呼び出し階層図

```
DisruptionController.trySync (735行目)
    |
    +-- buildDisruptedPodMap (761行目)
           |
           +-- 各Pod確認ループ (952行目)
                  |
                  +-- recorder.Eventf("NotDeleted") (966行目)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

PDB.Status.DisruptedPods ───> buildDisruptedPodMap ───> Event記録
+ Pod一覧                      (タイムアウト判定)          (NotDeleted)
                                      |
                                      v
                              新DisruptedPodsマップ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| disruption.go | `pkg/controller/disruption/disruption.go` | ソース | buildDisruptedPodMap, DeletionTimeout定数 |
| disruption_test.go | `pkg/controller/disruption/disruption_test.go` | テスト | NotDeleted イベントのテスト |
