# 通知設計書 126-OwnerRefInvalidNamespace

## 概要

本ドキュメントは、Kubernetes の garbagecollector（ガベージコレクタ）が発行する `OwnerRefInvalidNamespace` イベント通知の設計を記述する。オブジェクトのownerReferenceが指す所有者オブジェクトが、同一Namespace内に存在しない場合に発行される警告イベントである。

### 本通知の処理概要

本通知は、ガベージコレクタの GraphBuilder がオブジェクトの所有者（owner）を解決する際に、Namespacedリソースの ownerReference が同一 Namespace 内に存在するオブジェクトを指していない場合に発行される。

**業務上の目的・背景**：Kubernetesのガベージコレクションでは、ownerReferenceに基づいて依存関係を追跡する。ownerReferenceが不正なNamespaceを参照している場合、ガベージコレクションが正しく動作せず、オーファンリソースが発生する可能性がある。この通知により管理者は不正なownerReferenceを持つリソースを特定できる。

**通知の送信タイミング**：GraphBuilder がオブジェクトの所有者を解決する際（addDependentToOwners処理中）、ownerReferenceのUIDで参照される所有者が同一Namespace内に見つからない場合に発行される。

**通知の受信者**：Kubernetes Event として不正な ownerReference を持つオブジェクト自身に対して記録される。クラスタ管理者が参照する。

**通知内容の概要**：不正な ownerReference の詳細（Kind, APIVersion, Name, UID）と対象Namespaceが記録される。

**期待されるアクション**：クラスタ管理者は、不正な ownerReference を持つリソースを特定し、ownerReferenceを修正するか、不要なリソースを削除する。

## 通知種別

Kubernetes Event（Warning イベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（イベント記録） |
| 優先度 | 中（Warning） |
| リトライ | なし |

### 送信先決定ロジック

不正な ownerReference を持つオブジェクト自身に対してイベントが記録される。ObjectReferenceはオブジェクトのKind, APIVersion, Namespace, Name, UIDから構築される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventであり、メール送信は行わない。

### 本文テンプレート

```
ownerRef <invalidIdentity> does not exist in namespace "<Namespace>"
```

invalidIdentityの形式: `<APIVersion>/<Kind>/<Namespace>/<Name> (UID: <UID>)`

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| invalidIdentity | 不正なownerRefの情報 | ownerReference (Kind, APIVersion, Name, UID, Namespace) | Yes |
| Namespace | オブジェクトのNamespace | n.identity.Namespace | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ処理 | オブジェクトの所有者解決（addDependentToOwners） | ownerReferenceで参照されるオブジェクトが同一Namespace内に存在しない | GraphBuilder内の所有者UID解決失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ownerRefのUIDがuidToNodeに存在する | 正常に所有者が見つかった場合 |
| ownerRefのUIDに対応するownerRefが見つからない | reportInvalidNamespaceOwnerRef内でfound=falseの場合、イベント発行なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[オブジェクト変更イベント] --> B[GraphBuilder処理]
    B --> C[addDependentToOwners]
    C --> D{ownerRef解決}
    D -->|Namespace不一致| E[reportInvalidNamespaceOwnerRef]
    D -->|正常| F[依存関係登録]
    E --> G{ownerRefが見つかるか}
    G -->|Yes| H[ObjectReference構築]
    G -->|No| I[処理終了]
    H --> J[Warning Eventf OwnerRefInvalidNamespace]
    J --> K[attemptToDeleteに追加]
    F --> L[終了]
    I --> L
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 任意のKubernetesリソース | ownerReferenceの所有者検索 | uidToNodeグラフ内で管理 |

### テーブル別参照項目詳細

#### 対象オブジェクト

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| metadata.ownerReferences | 所有者参照の取得 | ガベージコレクタのインフォーマー経由 |
| metadata.uid | オブジェクト識別 | グラフノードのキー |
| metadata.namespace | Namespace確認 | 所有者との照合 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event（API リソース） | INSERT | Warning イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | Warning / OwnerRefInvalidNamespace | Kubernetes Event APIを通じて記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 本イベント自体が問題検出の通知 | attemptToDeleteキューに追加して削除を試みる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | ガベージコレクタのワークキューによる再試行 |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 削除処理失敗時 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

特に制限なし。

## セキュリティ考慮事項

本イベントにはオブジェクトのメタデータ情報（Kind, Name, Namespace, UID）が含まれるが、機密データは含まれない。

## 備考

- このイベントは2つの箇所（477行目と750行目）から呼び出される
- 477行目：addDependentToOwners でownerが同一Namespaceに見つからない場合
- 750行目：依存オブジェクトの再処理時にownerのNamespaceが一致しない場合

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | graph_builder.go | `pkg/controller/garbagecollector/graph_builder.go` | objectReference構造体とnode構造体の定義（identityフィールド, owners フィールド） |

**読解のコツ**: GraphBuilderがuidToNodeマップでオブジェクト間の依存関係グラフを管理している点に注目する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | graph_builder.go | `pkg/controller/garbagecollector/graph_builder.go` | reportInvalidNamespaceOwnerRef関数（504-534行目）がイベント発行の本体 |

**主要処理フロー**:
1. **504行目**: reportInvalidNamespaceOwnerRef関数開始
2. **507-512行目**: n.owners からinvalidOwnerUID に一致するownerRefを検索
3. **514-516行目**: 見つからなければreturn
4. **517-522行目**: ObjectReference構築（対象オブジェクト自身）
5. **524-532行目**: invalidIdentity構築（不正なownerRef情報）
6. **533行目**: eventRecorder.Eventf で OwnerRefInvalidNamespace イベント発行

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | graph_builder.go | `pkg/controller/garbagecollector/graph_builder.go` | 477行目（addDependentToOwners内）と750行目（依存オブジェクト再処理）の2つの呼び出し箇所 |

### プログラム呼び出し階層図

```
GraphBuilder.processGraphChanges
    |
    +-- addDependentToOwners
    |      +-- reportInvalidNamespaceOwnerRef (477行目)
    |             +-- eventRecorder.Eventf("OwnerRefInvalidNamespace") (533行目)
    |
    +-- 依存オブジェクト再処理
           +-- reportInvalidNamespaceOwnerRef (750行目)
                  +-- eventRecorder.Eventf("OwnerRefInvalidNamespace") (533行目)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

オブジェクト変更 ───> GraphBuilder ───> ownerRef解決 ───> Event記録
(ownerReferences)    (uidToNode照合)   (Namespace検証)   (OwnerRefInvalidNamespace)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| graph_builder.go | `pkg/controller/garbagecollector/graph_builder.go` | ソース | GraphBuilder, reportInvalidNamespaceOwnerRef |
| garbagecollector_test.go | `pkg/controller/garbagecollector/garbagecollector_test.go` | テスト | OwnerRefInvalidNamespaceのテスト |
