# 通知設計書 131-MultipleSELinuxLabels

## 概要

本ドキュメントは、Kubernetesにおいて同一ボリュームが異なるSELinuxラベルで複数回マウントされた際に発行されるWarningイベント「MultipleSELinuxLabels」の通知設計について記載する。

### 本通知の処理概要

本通知は、SELinuxが有効な環境において、同一ボリュームが複数のPodまたは同一Pod内の複数コンテナで異なるSELinuxラベルを使用してマウントされた場合に、Warningイベントとして発行される。この通知はselinux-warningコントローラによって管理される。

**業務上の目的・背景**：SELinuxが有効なクラスタでは、ボリュームに適用されるSELinuxラベルが一貫していることが重要である。異なるSELinuxラベルで同一ボリュームをマウントすると、ファイルアクセスの不整合やセキュリティ違反が発生する可能性がある。本通知は、このような潜在的な問題を早期に検知し、クラスタ管理者に警告することを目的としている。

**通知の送信タイミング**：Pod作成時にselinux-warningコントローラがPodのボリュームマウント設定を解析し、同一ボリュームが異なるSELinuxラベルでマウントされていることを検出した際にイベントが発行される。具体的には、(1) Pod内の複数コンテナが同一ボリュームを異なるSELinuxラベルで使用する場合（MultipleSELinuxLabels）、(2) 異なるPod間で同一ボリュームを異なるSELinuxラベルで使用する場合（SELinuxLabelConflict）、(3) 異なるPodが同一ボリュームに対して異なるSELinuxChangePolicyを使用する場合（SELinuxChangePolicyConflict）に発行される。

**通知の受信者**：対象Podに関連するKubernetesイベントとして記録されるため、kubectl describe pod等でPodを参照するクラスタ管理者やアプリケーション開発者が受信者となる。

**通知内容の概要**：同一ボリュームが異なるSELinuxラベルでマウントされた旨を示す警告メッセージ。ボリューム名と競合の詳細を含む。

**期待されるアクション**：受信者はPodのSecurityContextおよびSELinuxOptionsの設定を確認し、同一ボリュームを使用するコンテナまたはPod間でSELinuxラベルを統一する。必要に応じてSELinuxChangePolicyの設定を見直す。

## 通知種別

Kubernetesイベント（Event API）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（コントローラのワークキュー経由） |
| 優先度 | 中 |
| リトライ | 有・RateLimitingQueue による自動リトライ |

### 送信先決定ロジック

イベントは対象PodのObjectReferenceに紐付けて記録される。Pod内での競合の場合は当該Podに対してイベントが発行される。Pod間での競合の場合は競合に関与する各Podに対してそれぞれイベントが発行される。

## 通知テンプレート

### Kubernetesイベント

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | MultipleSELinuxLabels / SELinuxLabelConflict / SELinuxChangePolicyConflict |
| Component | selinux_warning |

### 本文テンプレート

Pod内の同一ボリュームに対する異なるSELinuxラベル:
```
Volume %q is mounted twice with different SELinux labels inside this pod
```

Pod間でのSELinuxラベル競合:
```
Pod uses volume %q with %s %q, but pod %s uses the same volume with %s %q
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | Kubernetesイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| mount (ボリューム名) | 競合が発生したボリュームの名前 | Pod.Spec.Volumes[].Name | Yes |
| PropertyName | 競合のプロパティ名（SELinuxLabel/SELinuxChangePolicy） | volumeCache判定結果 | Yes |
| PropertyValue | 当該PodのSELinuxラベルまたはChangePolicy値 | PodSecurityContext / SELinuxOptions | Yes |
| OtherPod | 競合する他のPod名 | volumeCache内のPod情報 | Yes |
| OtherPropertyValue | 競合する他のPodのSELinuxラベルまたはChangePolicy値 | volumeCache内のPod情報 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Pod作成 | PodのInformer AddFunc | Pod内の同一ボリュームが異なるSELinuxラベルを持つ | Pod内競合検出 |
| Pod作成/更新 | PodのInformer AddFunc/UpdateFunc | 異なるPodが同一ボリュームを異なるSELinuxラベルで使用 | Pod間競合検出 |
| PVC/PVバインド | PVC/PV Informer UpdateFunc | PVC/PVバインド後にPodの再評価 | ボリュームバインド契機 |
| CSIDriverの変更 | CSIDriver Informer Add/Update/DeleteFunc | CSIDriverのSELinuxMountフラグ変更 | CSIDriver設定変更契機 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SELinux無効 | クラスタでSELinuxが無効な場合、コントローラは何もしない |
| Pod終了状態 | PodがFailed/Succeeded状態の場合、ボリュームキャッシュから削除される |
| SELinuxChangePolicyがRecursive | Recursive ポリシーの場合、空ラベルとして扱われ競合が報告されない |
| 同一ラベル | 同一ボリュームを使用するPod間でSELinuxラベルが同一の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Pod/PVC/PV/CSIDriver変更イベント] --> B[ワークキューにPodを追加]
    B --> C[syncPod: Podのボリューム解析]
    C --> D[GetPodVolumeNames: SELinuxラベル収集]
    D --> E[GetMountSELinuxLabel: ラベル算出]
    E --> F{Pod内で複数ラベル?}
    F -->|Yes| G[MultipleSELinuxLabelsイベント発行]
    F -->|No| H[syncVolume: ボリュームキャッシュ更新]
    H --> I[volumeCache.AddVolume]
    I --> J{他Podとの競合?}
    J -->|Yes| K[reportConflictEvents: 競合イベント発行]
    J -->|No| L[終了]
    G --> L
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | ボリューム情報、SELinuxラベル取得 | Informerキャッシュ経由 |
| PersistentVolumeClaim | PVCバインド情報取得 | Informerキャッシュ経由 |
| PersistentVolume | PVスペック取得 | Informerキャッシュ経由 |
| CSIDriver | SELinuxMountサポート確認 | Informerキャッシュ経由 |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.Volumes | ボリューム一覧の取得 | 対象Pod |
| Spec.SecurityContext.SELinuxOptions | PodレベルのSELinuxラベル取得 | 対象Pod |
| Spec.SecurityContext.SELinuxChangePolicy | SELinux変更ポリシー取得 | 対象Pod |
| Spec.Containers[].SecurityContext.SELinuxOptions | コンテナレベルのSELinuxラベル取得 | 対象Pod |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | 警告イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Warning | イベントタイプ |
| INSERT | Reason | MultipleSELinuxLabels / SELinuxLabelConflict / SELinuxChangePolicyConflict | イベント理由 |
| INSERT | Message | 競合の詳細メッセージ | 動的生成 |
| INSERT | Source.Component | selinux_warning | イベントソース |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ボリュームスペック作成失敗 | PVC/PVが存在しない | エラーログを記録し、当該ボリュームをスキップ |
| プラグイン未検出 | ボリュームプラグインが登録されていない | スキップ（SELinuxに影響しないプラグインの可能性） |
| SELinuxラベル取得失敗 | ラベル変換エラー | エラーログを記録し、当該ボリュームをスキップ |
| Pod取得失敗 | Podが削除済み | 競合イベントの発行をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（RateLimitingQueue） |
| リトライ間隔 | 指数バックオフ（DefaultTypedControllerRateLimiter） |
| リトライ対象エラー | sync関数が非nilエラーを返した場合 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯制限なし。コントローラが稼働中は常時イベントが発行される。

## セキュリティ考慮事項

- 本通知はSELinuxのセキュリティラベル情報を含むため、イベントへのアクセスにはRBACによる適切な権限制御が必要
- selinux-warningコントローラはAPIオブジェクトの変更を行わず、イベントの発行のみを行う（読み取り専用に近い動作）
- SELinuxラベルの競合はセキュリティ違反につながる可能性があるため、本通知を無視すべきではない

## 備考

- SELinuxWarningコントローラはオプションのコントローラであり、SELinuxが無効なクラスタでは何も行わない
- コントローラはPodが実際にどのノードで動作するか、または正しいアンチアフィニティを持つかに関わらず、全てのPodのボリューム競合を報告する
- メトリクスも同時に記録され、Prometheusで監視可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SELinuxラベルの競合検出で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | volumecache.go | `pkg/controller/volume/selinuxwarning/cache/volumecache.go` | VolumeCache, usedVolume, podInfo, Conflict型の定義（29-95行目） |
| 1-2 | selinux.go | `pkg/volume/util/selinux.go` | MultipleSELinuxLabelsError型、SELinuxLabelInfo型の定義（210-249行目） |

**読解のコツ**: volumeCacheがボリューム単位でPodのSELinuxラベルとChangePolicyを管理している。Conflict構造体がイベント生成の元となる。

#### Step 2: エントリーポイントを理解する

コントローラの初期化とInformerフックの登録を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | selinux_warning_controller.go | `pkg/controller/volume/selinuxwarning/selinux_warning_controller.go` | Controller構造体（63-84行目）とNewController関数（86-179行目） |

**主要処理フロー**:
1. **86-179行目**: NewControllerでInformerフックを登録。Pod、PVC、PV、CSIDriverの各変更イベントをワークキューに変換
2. **142-146行目**: Pod Informerのイベントハンドラ（Add/Update/Delete）
3. **181-187行目**: enqueuePod: Podをワークキューにエンキュー

#### Step 3: 同期処理を理解する

Pod同期の主要ロジックを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | selinux_warning_controller.go | `pkg/controller/volume/selinuxwarning/selinux_warning_controller.go` | sync関数（412-431行目）、syncPod関数（441-491行目）、syncVolume関数（493-532行目） |

**主要処理フロー**:
- **412-431行目**: sync: PodをListerから取得し、状態に応じてsyncPodまたはsyncPodDeleteを呼び出す
- **449-458行目**: syncPod: 各ボリュームのSpecを事前計算
- **460-488行目**: GetPodVolumeNames→GetMountSELinuxLabel→MultipleSELinuxLabelsErrorの検出とイベント発行
- **472-473行目**: Pod内の異なるSELinuxラベルを検出し「MultipleSELinuxLabels」イベントを発行
- **493-532行目**: syncVolume: ボリュームキャッシュにラベルを追加し、Pod間の競合を検出

#### Step 4: 競合検出とイベント発行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | volumecache.go | `pkg/controller/volume/selinuxwarning/cache/volumecache.go` | AddVolume関数（98-171行目）。ラベル競合とChangePolicy競合の検出ロジック |
| 4-2 | selinux_warning_controller.go | `pkg/controller/volume/selinuxwarning/selinux_warning_controller.go` | reportConflictEvents関数（534-544行目）。競合に対するイベント発行 |

### プログラム呼び出し階層図

```
Controller.Run (357行目)
    |
    +-- processNextWorkItem (391行目)
           |
           +-- sync (412行目)
                  |
                  +-- syncPod (441行目)
                  |      |
                  |      +-- util.CreateVolumeSpec (450行目)
                  |      +-- volumeutil.GetPodVolumeNames (460行目)
                  |      +-- volumeutil.GetMountSELinuxLabel (469行目)
                  |      |      |
                  |      |      +-- MultipleSELinuxLabelsError検出 (287-289行目 selinux.go)
                  |      |
                  |      +-- eventRecorder.Eventf "MultipleSELinuxLabels" (473行目)
                  |      +-- syncVolume (484行目)
                  |             |
                  |             +-- volumeCache.AddVolume (528行目)
                  |             |      |
                  |             |      +-- SELinuxLabel/ChangePolicyの競合検出 (132-170行目 volumecache.go)
                  |             |
                  |             +-- reportConflictEvents (529行目)
                  |                    |
                  |                    +-- eventRecorder.Event (542行目)
                  |
                  +-- syncPodDelete (433行目)
                         |
                         +-- volumeCache.DeletePod (437行目)
```

### データフロー図

```
[入力]                        [処理]                                [出力]

Pod Informer --------+
                     |
PVC Informer --------+----> Controller.sync -----> syncPod -----> Kubernetes Event
                     |           |                    |             (MultipleSELinuxLabels /
PV Informer ---------+           |                    |              SELinuxLabelConflict /
                     |           |                    v              SELinuxChangePolicyConflict)
CSIDriver Informer --+           |               syncVolume
                                 |                    |
                                 v                    v
                            Work Queue          VolumeCache
                                                  (in-memory)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| selinux_warning_controller.go | `pkg/controller/volume/selinuxwarning/selinux_warning_controller.go` | ソース | メインコントローラ。Pod同期、競合検出、イベント発行 |
| volumecache.go | `pkg/controller/volume/selinuxwarning/cache/volumecache.go` | ソース | ボリュームキャッシュ。ラベル・ポリシー競合検出 |
| volumecache_test.go | `pkg/controller/volume/selinuxwarning/cache/volumecache_test.go` | テスト | ボリュームキャッシュのユニットテスト |
| selinux.go | `pkg/volume/util/selinux.go` | ソース | SELinuxラベル処理ユーティリティ。MultipleSELinuxLabelsError定義 |
| metrics.go | `pkg/controller/volume/selinuxwarning/metrics.go` | ソース | Prometheusメトリクス登録 |
| volumehost.go | `pkg/controller/volume/selinuxwarning/volumehost.go` | ソース | ボリュームプラグインホスト実装 |
| selinux_warning_controller_test.go | `pkg/controller/volume/selinuxwarning/selinux_warning_controller_test.go` | テスト | コントローラのユニットテスト |
| core.go | `cmd/kube-controller-manager/app/core.go` | ソース | コントローラマネージャからの起動設定 |
| controller_names.go | `cmd/kube-controller-manager/names/controller_names.go` | ソース | コントローラ名定義 |
